#define MIX_ELEMENT_CPP_

#include <iostream>
#include <numeric>

#include "Element.h"
#include "XMLString.h"
#include "DOM_Exception.h"

namespace MiX{
  //dmy_itcreate軰ά뤿Υȥå
  template <class Char,class Traits,class XMLTraits>
  const NodeList<Char,Traits,XMLTraits>::iterator 
  Element<Char,Traits,XMLTraits>::dmy_it=NodeList<Char,Traits,XMLTraits>::iterator();

  
  template <class Char,class Traits,class XMLTraits>
  XMLString<Char,Traits,XMLTraits> Element<Char,Traits,XMLTraits>::getText()const{
    string_type ret;
    nodelist_type::const_iterator it = getChildren().begin();
    nodelist_type::const_iterator last = getChildren().end();
    
    for( ;it!=last;++it){
      if((*it)->getType()==Node_Text){
	const text_type& txt =dynamic_cast<const text_type&>(**it);
	ret+=txt.getValue();
      }
    }
    return ret;    
  };
  
  template <class Char,class Traits,class XMLTraits>
  void Element<Char,Traits,XMLTraits>::setText(const XMLString<Char,Traits,XMLTraits>& s){
    nodelist_type lst = getChildren();
    nodelist_type::iterator it = lst.begin();
    nodelist_type::iterator last = lst.end();
    
    for( ;it!=last;++it){
      if((*it)->getType()==Node_Text){
	(*it)->destroy(); 
      }
    }
    Text<Char,Traits,XMLTraits>::create(s,*this);
  };
  
  template <class Char,class Traits,class XMLTraits>
  XMLString<Char,Traits,XMLTraits> Element<Char,Traits,XMLTraits>::toString(bool is_indent,int indent_off)const{
    string_type s;
    if(is_indent) insertIndent(indent_off,s,XMLTraits::tab());
    s += XMLTraits::lt();s += getName();
    nodelist_type::const_iterator it = getChildren().begin();
    nodelist_type::const_iterator last = getChildren().end();
    for( ;it!=last;++it)
      if((*it)->getType()==Node_Attribute){
	s += XMLTraits::sp();
	s += (*it)->toString();
      }
    string_type children;
    bool b = false;
    for(it=getChildren().begin();it!=last;++it){
      if((*it)->getType()!=Node_Attribute){
	b=true; children+=(*it)->toString(is_indent,indent_off+1);
      }
    }
    if(b){
      s += XMLTraits::gt(); 
      if(is_indent) s+=XMLTraits::crlf();
      s += children;
      if(is_indent) insertIndent(indent_off,s,XMLTraits::tab());
      s += XMLTraits::lt(); s += XMLTraits::slash();
      s += getName(); s += XMLTraits::gt();
      if(is_indent) s+=XMLTraits::crlf();
    }else{
      s += XMLTraits::slash(); s += XMLTraits::gt();
      if(is_indent) s+=XMLTraits::crlf();
    }
    return s;
  };

  //Ĺ
  template <class Char,class Traits,class XMLTraits>
  Element<Char,Traits,XMLTraits>& Element<Char,Traits,XMLTraits>::create(const XMLString<Char,Traits,XMLTraits>& name,Element<Char,Traits,XMLTraits>& parent,const typename NodeList<Char,Traits,XMLTraits>::iterator& it){
    this_type* newel = new this_type(name);
    newel->setParent(parent);
    if(&it==&dmy_it)
      parent.getChildren().insert(parent.getChildren().end(),newel);
    else parent.getChildren().insert(it,newel);
    return *newel;
  }
  
}
