// -*- mode: c++ -*-

#ifndef MIX_ELEMENT_H_
#define MIX_ELEMENT_H_

#include "classes.h"
#include "misc.h"
#include "NodeContainer.h"

namespace MiX{
  /**
   * XMLɥΥȤɽ饹Ǥ
   *
   * ̾Ҥʣݻޤ
   */
  template <class Char,class Traits,class XMLTraits>
  class Element 
    : public NodeContainer<Char,Traits,XMLTraits>, 
      public NamedNode<Char,Traits,XMLTraits>{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef Element<Char,Traits,XMLTraits> this_type;
    typedef NodeContainer<Char,Traits,XMLTraits> nodecontainer_type;
  private:
    const static nodelist_type::iterator dmy_it;
  protected:
    /**
     * 󥹥ȥ饯
     *
     *  ElementΥ󥹥ȥ饯ľܸƤ٤ޤ<br>
     *  Element<...>::createƤ
     */
    Element(const string_type& name)
      : NodeContainer<Char,Traits,XMLTraits>(),
	NamedNode<Char,Traits,XMLTraits>(name){ };
    /**
     * ԡ󥹥ȥ饯
     *
     * ElementϥԡǤޤ
     */
    Element(const this_type& src){ };
  public:
    /// ǥȥ饯
    virtual ~Element()throw(){ };
    /// ΥΡɤΥפޤ
    virtual NodeType getType()const{ return Node_Element; };
    /**
     * Ū˥饹NodeTypeޤ
     *
     * Node_Element֤ޤ
     */
    static NodeType type(){ return Node_Element; };
    /**
     * Element˥ޤ
     *
     * szNameͿ줿̾iIndexܤElementؤλȤ֤ޤ
     * ĤʤäDomException<...>ꤲޤ
     */
    this_type& operator() (const string_type& name,int index=0){
      return getElement(name,index);
    };
    /**
     * Attribute˥ޤ
     *
     * szNameͿ줿̾AttributeؤλȤ֤ޤ
     * ĤʤäDomException<...>ꤲޤ
     */
    attribute_type& operator[] (const string_type& name){
      return getAttribute(name);
    };
    /**
     * Elementʸɽޤ
     *
     *  bIndentλǥȤɲäޤ
     */
    virtual XMLString<Char,Traits,XMLTraits> toString(bool is_indent=false,int indent_off=0)const;

    ///TextͤϢ뤷֤ޤ
    string_type getText()const;

    ///Textƾä塢sͤĻTextޤ
    void setText(const XMLString<Char,Traits,XMLTraits>& s);

    /**
     * Elementޤ
     *
     * <dl>
     *  <dt>name</dt><dd>Element̾</dd>
     *  <dt>parent</dt><dd>ElementοƥΡ</dd>
     *  <dt>it</dt><dd>(parent.getChilds()Ǥ򼨤ƥ졼ǤʤƤϤʤޤ)</dd>
     * </dl>
     */
    static this_type& create(const string_type& name,this_type& parent,const typename nodelist_type::iterator& it = dmy_it);

#ifdef MiX_BACKWARD_COMPATIBILITY
    ///TextͤϢ뤷֤ޤ
    XMLString<Char,Traits,XMLTraits> getAllChildValue(){
      return getText();
    }
#endif

    friend class DOM_Parser<Char,Traits,XMLTraits>;
    friend class Document<Char,Traits,XMLTraits>;
  };
}

#ifndef MIX_ELEMENT_CPP_
#include "Element.cpp"
#endif

#endif
