// -*- mode: c++ -*-

#ifndef MIX_NODE_H_
#define MIX_NODE_H_

#include "classes.h"
#include "misc.h"
#include "DefaultXMLTraits.h"

namespace MiX{
  /**
   * ƤNodeδ쥯饹
   *
   * ƥΡɤؤΥ˴ʤɤεǽ󶡤ʸ󲽤ʤɤΥ󥿥եꤹ
   */
  template <class Char,class Traits,class XMLTraits>
  class Node{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef NamedNode<Char,Traits,XMLTraits> this_type;
    typedef NodeContainer<Char,Traits,XMLTraits> nodecontainer_type;
  private:
    NodeContainer<Char,Traits,XMLTraits>* parent_;
  protected:
    /**
     * ԡ󥹥ȥ饯
     *
     * 饤ȤϤƤӽФʤĤޤꥳԡǤʤ
     */
    Node(const this_type& src){ };
    ///󥹥ȥ饯
    Node(){ parent_ = 0; };
    ///ƥΡɤ
    void setParent(nodecontainer_type& parent){ parent_ = &parent; };
  public:
    /// ǥȥ饯
    virtual ~Node()throw();
    /// ˴
    virtual void destroy()throw() { delete this; } ;
    /// ƥΡɤؤλȤޤ(const)
    const nodecontainer_type& getParent() const;
    /// ƥΡɤؤλȤޤ
    nodecontainer_type& getParent();
    /// ΥΡɤΥפޤ
    virtual NodeType getType() const = 0;
    /// Nodeʸɽޤ
    virtual string_type toString(bool indent=false,int indent_off=0)const = 0;

    friend class DOM_Parser<Char,Traits,XMLTraits>;
    friend class NodeContainer<Char,Traits,XMLTraits>;
  };
}

#ifndef MIX_NODE_CPP_
#include "Node.cpp"
#endif

#endif
