// -*- mode: c++ -*-

#ifndef MIX_NODECONTAINER_H_
#define MIX_NODECONTAINER_H_

#include "NodeList.h"
#include "Node.h"

namespace MiX{
  /**
   * ҥΡɤݻNodeδ쥯饹
   *
   * ҥΡɤ˴ؤ륢
   */
  template <class Char,class Traits,class XMLTraits>
  class NodeContainer : virtual public Node<Char,Traits,XMLTraits>{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef NodeContainer<Char,Traits,XMLTraits> this_type;
  protected:
    NodeList<Char,Traits,XMLTraits> children_;
    void addChild(node_type* node);
  protected:
    ///󥹥ȥ饯
    NodeContainer() : Node<Char,Traits,XMLTraits>(){ };
    /**
     * ԡ󥹥ȥ饯
     *
     * 饤ȤϤƤӽФʤĤޤꥳԡǤʤ
     */
    NodeContainer(const this_type& src){ };
  public:
    ///ǥȥ饯
    virtual ~NodeContainer()throw();
    ///ҥΡɤΥꥹȤؤλȤޤ
    nodelist_type& getChildren(){ return children_; };
    ///ҥΡɤΥꥹȤؤλȤޤ(const)
    const nodelist_type& getChildren()const{ return children_; };
    ///ȥӥ塼Ȥ¸ߤ뤫ɤ
    bool hasAttribute(const string_type& n);
    ///ҥȤޤ
    Element<Char,Traits,XMLTraits>& getElement(const XMLString<Char,Traits,XMLTraits>& name,int index);
    ///ҥȥӥ塼Ȥޤ
    Attribute<Char,Traits,XMLTraits>& getAttribute(const XMLString<Char,Traits,XMLTraits>& nm);
    
#ifdef MiX_BACKWARD_COMPATIBILITY
    ///Ѥ餷ߴ
    NodeList<Char,Traits,XMLTraits>& getChilds(){
      return getChildren();
    };
    ///Ѥ餷ߴ
    const NodeList<Char,Traits,XMLTraits>& getChilds()const{
      return getChildren();
    }
#endif

    friend class DOM_Parser<Char,Traits,XMLTraits>;
  };
}

#ifndef MIX_NODECONTAINER_CPP_
#include "NodeContainer.cpp"
#endif

#endif
