// -*- mode: c++ -*-

#ifndef MIX_SAXPARSER_H_
#define MIX_SAXPARSER_H_

#include <map>
#include <stack>

#include "classes.h"
#include "DefaultXMLTraits.h"
#include "misc.h"
#include "Tokenizer.h"
#include "SAX_EventHandler.h"
#include "XMLString.h"
#include "AttrMap.h"

namespace MiX{
  /**
   * Ϳ줿ʸϤSAX_EventHandlerŬڤʥ٥Ȥ򵯤饹
   * TokenizerѤƤ
   */
  template <class Char,class Traits,class XMLTraits>
  class SAX_Parser{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef SAX_Parser<Char,Traits,XMLTraits> this_type;
    typedef NodeContainer<Char,Traits,XMLTraits> nodecontainer_type;
  private:
    enum State{
      STATE_Text,
      STATE_Tag,
      STATE_Reference,
      STATE_Comment,
      STATE_Complete,
      STATE_Declaration,
      STATE_XMLDeclaration,
      STATE_Escape,
      STATE_Exception
    };

    State state_;
    Tokenizer<Char,Traits,XMLTraits> tokenizer_;
    SAX_EventHandler<Char,Traits,XMLTraits>* handler_;
    MiX_STD::stack<XMLString<Char,Traits,XMLTraits> > validator_;
    //ѡ󥰥ץ - 
    bool ignore_space_;

    void skipSpaceTokens();
    //ѡ
    State parseText();
    State parseTag();
    State parseComment();
    State parseDeclaration();
    State parseXMLDeclaration();
    //ѡ(ѡΥإ)
    AttrMap<Char,Traits,XMLTraits> parseAttributes();
    XMLString<Char,Traits,XMLTraits> parseReference();
    //إѴؿ
    void trimRight(XMLString<Char,Traits,XMLTraits>& str);
  public:
    ///󥹥ȥ饯
    SAX_Parser(){ handler_ = NULL; };
    /**
     * ٥ȥϥɥꤷޤ
     *
     * <dl><dt>handler</dt>
     * <dd>٥Ȥϥɥɽ֥ȤؤΥݥ</dd></dl>
     */
    void setEventHandler(SAX_EventHandler<Char,Traits,XMLTraits>* handler){
      handler_ = handler;
    };
    /**
     * ʸˤ(ǥ)̵뤹뤫ɤꤷޤ
     *
     * setIgnoreSpace(true)򤷤硢ǥˤä줿
     * XMLɥȤñ˽뤳ȤǤޤ
     */
    void setIgnoreSpace(bool flag) { ignore_space_ = flag; };
    /**
     * Ϳ줿ʸϤSaxEventHandlerŬڤʥ٥Ȥ򵯤ޤ
     *
     * handlerꤷƤʤäParsingExceptionꤲޤ
     * <dl><dt>szText</dt><dd>Ϥʸ</dd></dl>
     */
    bool parse(const Char* szText);
  };
}

#ifndef MIX_SAXPARSER_CPP_
#include "SAX_Parser.cpp"
#endif

#endif
