#define MIX_TOKENIZER_CPP_

#include "Tokenizer.h"


namespace MiX{

  //ȡ
  template<class Char,class Traits,class XMLTraits> 
  const Char Tokenizer<Char,Traits,XMLTraits>::tokens_[15] = {
    XMLTraits::null(),XMLTraits::crlf(),XMLTraits::sp(),
    XMLTraits::tab(),XMLTraits::lt(),XMLTraits::eq(),XMLTraits::gt(),
    XMLTraits::slash(),XMLTraits::hyphen(),//XMLTraits::colon(),
    XMLTraits::semicolon(),XMLTraits::exclamation(),
    XMLTraits::question(),XMLTraits::amp(),XMLTraits::dblquote(),
    XMLTraits::quote(), 
  };
  
  template<class Char,class Traits,class XMLTraits> 
  bool Tokenizer<Char,Traits,XMLTraits>::ejectToken(XMLToken<Char,Traits,XMLTraits>& dest){
    //å˵ͤޤ줿ȡ󤬻ĤäƤСФ롣
    if(!stack_.empty()){
      dest = stack_.top(); 
      stack_.pop();
      return true;
    }
    if(*current_==XMLTraits::null()){
      XMLToken<Char,Traits,XMLTraits> tok(current_,current_+1,Token_null,current_-start_);
      dest = tok;
      return false;
    }
    TokenType type;
    if(Token_text!=(type=isToken(*current_))){
      XMLToken<Char,Traits,XMLTraits> tok(current_,current_+1,type,current_-start_);
      current_++;
      dest = tok;
      return true;
    }
    const Char* mark = current_;
    while(Token_text==isToken(*(current_+1))){
      current_++;
    }
    long lSize = current_-mark+1;
    XMLToken<Char,Traits,XMLTraits> tok(mark,mark+lSize,Token_text,mark-start_);
    current_++;
    dest = tok;
    return true;
  }
    
  template<class Char,class Traits,class XMLTraits>
  TokenType Tokenizer<Char,Traits,XMLTraits>::isToken(Char c){
    int nTokens = sizeof(tokens_) / sizeof(Char);
    for(int i=0;i<nTokens;++i)
      if(tokens_[i]==c) return static_cast<TokenType>(i);
    return Token_text;
  }
}
