// -*- mode: C++ -*-
#ifndef MIX_TEST_STRESS_H_
#define MIX_TEST_STRESS_H_

#include <Document.h>
#include <Element.h>
#include <Attribute.h>
#include <Text.h>
#include <Comment.h>

#include "MBC.h"

#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>

#define MiX_Test_STRESS 100

class StressTest : public CppUnit::TestCase{
  typedef MiX::Document<char> Document;
  typedef MiX::Document<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> DocumentMBC;
  typedef MiX::Element<char> Element;
  typedef MiX::Element<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> ElementMBC;
  typedef MiX::Attribute<char> Attribute;
  typedef MiX::Attribute<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> AttributeMBC;
  typedef MiX::Text<char> Text;
  typedef MiX::Text<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> TextMBC;
  typedef MiX::Comment<char> Comment;
  typedef MiX::Comment<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> CommentMBC;
  typedef MiX::DomParser<char> DomParser;
  typedef MiX::DomParser<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> DomParserMBC;

  static int* data_;
  static std::string doc_str_;
  static MBChar::MBCString doc_mbcs_;

  void testCreate();
  void testVerify();
  void testDestroy();
public:
  static CppUnit::TestSuite* suite();

};

#endif
