// -*- mode: c++ -*-

#ifndef MIX_DOMPARSER_H_
#define MIX_DOMPARSER_H_

#include "classes.h"
#include "DefaultXMLTraits.h"
#include "SAX_Parser.h"

namespace MiX{

  template <class charT,class char_traits,class xml_traits>
  class DOM_Parser : public SAX_EventHandler<charT,char_traits,xml_traits>{
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef DOM_Parser<charT,char_traits,xml_traits> this_type;
  private:
    ///ۂɃp[WOSAX_Parser
    SAX_Parser<charT,char_traits,xml_traits> parser_;
    ///ݍ\z̃m[h
    NodeContainer<charT,char_traits,xml_traits>* current_;
    /// ͂OԐ錾o^B
    void parseAttribute(const attrmap_type& attr);
  protected:
    ///SAX_Parser̂߂̃nh(p̂)
    virtual void onXMLDeclaration(attrmap_type attr);
    ///SAX_Parser̂߂̃nh(p̂)
    virtual void onStart(string_type name,attrmap_type attr);
    ///SAX_Parser̂߂̃nh(p̂)
    virtual void onEnd(string_type name);
    ///SAX_Parser̂߂̃nh(p̂)
    virtual void onText(string_type text);
    ///SAX_Parser̂߂̃nh(p̂)
    virtual void onComment(string_type text);
  public:
    ///fXgN^
    virtual ~DOM_Parser(){ };


    /**
     * ̑Oɂ(Cfg)𖳎邩ǂݒ肵܂
     *
     * setIgnoreSpace(true)ꍇACfgɂĐ`ꂽ
     * XMLhLgȒPɏ邱Ƃł܂
     */
    void setIgnoreSpace(bool flag){ parser_.setIgnoreSpace(flag); };
#ifndef MiX_BACKWARD_COMPATIBILITY
    ///^ꂽƂDOMc[\z܂
    document_type* parse(const charT* text);
#ifdef MiX_HAS_BASIC_STREAM
    ///^ꂽXg[ƂDOMc[\z܂
    document_type* parse(std::basic_istream<charT, char_traits>& is);
#endif//MiX_HAS_BASIC_STREAM
#else//MiX_BACKWARD_COMPATIBILITY
    ///^ꂽƂDOMc[\z܂
    document_type& parse(const charT* text);
#ifdef MiX_HAS_BASIC_STREAM
    ///^ꂽXg[ƂDOMc[\z܂
    document_type& parse(std::basic_istream<charT, char_traits>& is);
#endif//MiX_HAS_BASIC_STREAM
#endif//MiX_BACKWARD_COMPATIBILITY
  };
}

#ifndef MiX_DOMPARSER_CPP_
#include "DOM_Parser.cpp"
#endif

#endif
