// -*- mode: c++ -*-
#ifndef MiX_MISC_H_
#define MiX_MISC_H_

/** \file misc
 *   ɒuĂ̂͂Ő錾Ă܂
 */

#include "classes.h"

#include "DefaultTraits.h"

namespace MiX{
  /**
   * m[h̃^Cv\񋓌^ł
   *
   * 4rbg = 0,[IsNodeContainer],[IsNamedNode],[IsValue]
   * 4rbg̓j[NȒl
   */
  enum NodeType{
    Node_Document = 0x40,
    Node_Element = 0x60,
    Node_Attribute = 0x30,
    Node_Text = 0x10,
    Node_Comment = 0x11,
    //ȉ̒l͎ۂ̃m[hɂ͎gpȂB
    Node_NodeContainer = 0x40,
    Node_NamedNode = 0x20,
    Node_Value = 0x10,
  };
  
  ///G[^Cv\񋓌^ł
  enum ErrorType{
    // for ParsingException
    UnexpectedToken = 0,
    XMLDeclarationNotFound,
    InternalError,
    UnexpectedEOD,
    InvalidHandler,
    InvalidDeclaration,
    MismatchTag,
    // for DomException
    NullException,
    NodeNotFound,
    NodeDuplication,
    InvalidNodeFound,
    NamespaceNotDefined,
    // for XPathException
    InvalidXPathResult,
    InvalidDocument
  };

  /// toStringȂǂŗp镶Ɏw萔tabǉ֐ł
  template<class charT,class traitsT>
  XMLString<charT,traitsT> make_indent(int off,const XMLString<charT,traitsT>& idt){
    XMLString<charT,traitsT> ret;
    for( int i=0 ; i<off ; ++i ) ret+=idt;
    return ret;
  }
  /*
  template<class charT,class traitsT>
  void insertIndent(int i,XMLString<charT,traitsT>& str,charT c){
    for(int j=0;j<i;j++) str+=c;
    }*/


#define MiX_Template_Typedef(C,T,X) typedef C char_type; \
    typedef T char_traits_type; \
    typedef X xml_traits_type; \
    typedef Node<C,T,X> node_type; \
    typedef NodeContainer<C,T,X> nodecontainer_type; \
    typedef NamedNode<C,T,X> namednode_type; \
    typedef Value<C,T,X> value_type; \
    typedef Document<C,T,X> document_type; \
    typedef Element<C,T,X> element_type; \
    typedef Attribute<C,T,X> attribute_type; \
    typedef Text<C,T,X> text_type; \
    typedef Comment<C,T,X> comment_type; \
    typedef AttrMap<C,T,X> attrmap_type; \
    typedef XMLString<C,T,X> string_type; \
    typedef NodeList<C,T,X> nodelist_type; \
    typedef DOM_Exception<C,T,X> dom_exception_type; \
    typedef XPathAtom<C,T,X> xpathatom_type; \
    typedef XPathResult<C,T,X> xpathresult_type;	\
    typedef XPathException<C,T,X> xpathexception_type
}

#endif
