//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include "../src/MiX/DOM_Parser.h"
#include "../src/MiX/Document.h"
#include "../src/MiX/Element.h"
#include "../src/MiX/Attribute.h"
#include "../src/MiX/Text.h"

#define T(str) MiX::XMLString<char>( str )
#define URL_BOOK "urn:loc.gov:books"
#define URL_ISBN "urn:ISBN:0-395-36341-6"
#define URL_HTML "urn:w3-org-ns:HTML"

//CUPPA:namespace=+
//CUPPA:namespace=-

class DOM_ParserWithNSTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(DOM_ParserWithNSTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testParseBuffer);
  CPPUNIT_TEST(testParseStream);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...
  static const char data_[];
  void testImpl(MiX::Document<char>& doc) {
    CPPUNIT_ASSERT_EQUAL( T("1.0"), doc["version"].getValue() );
    CPPUNIT_ASSERT_EQUAL( T("book"), doc.getRoot().getName() );
    CPPUNIT_ASSERT_EQUAL( T(URL_BOOK), doc.getRoot().getURI() );
    CPPUNIT_ASSERT_EQUAL( T("Cheaper by the Dozen"),
			  doc.getRoot()("title",URL_BOOK).getText() );
    CPPUNIT_ASSERT_EQUAL( T("1568491379"),
			  doc.getRoot()("number",URL_ISBN).getText() );
    CPPUNIT_ASSERT_EQUAL( T("This is a  book!"),
			  doc.getRoot()("notes",URL_BOOK)("p",URL_HTML).getText() );
    CPPUNIT_ASSERT_EQUAL( T("1568491379"),
			  doc.getRoot()("isbn:number").getText() );

    //CPPUNIT_ASSERT_EQUAL( T(data_), doc.toString() );
  }

public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
  void testParseBuffer() {
    MiX::DOM_Parser<char> parser;
    parser.setIgnoreSpace(false);
    MiX::Document<char>* doc = parser.parse(data_);
    testImpl(*doc);
    delete doc;
  }
  void testParseStream() {
    std::istringstream ss(data_);
    MiX::DOM_Parser<char> parser;
    parser.setIgnoreSpace(false);
    MiX::Document<char>* doc = parser.parse(ss);
    testImpl(*doc);
    delete doc;
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

const char DOM_ParserWithNSTest::data_[] = {
  "<?xml version=\"1.0\"?>"
  "<!-- ͤȤƤΥǥե֤̾\"books\"Ȥ롣-->"
  "<book xmlns=\"urn:loc.gov:books\" xmlns:isbn=\"urn:ISBN:0-395-36341-6\">"
  "<title>Cheaper by the Dozen</title>"
  "<isbn:number>1568491379</isbn:number>"
  "<notes>"
  "<!-- Τˡǥե֤̾HTMLȤ롣-->"
  "<p xmlns=\"urn:w3-org-ns:HTML\">"
  "This is a <i>funny</i> book!"
  "</p>"
  "</notes>"
  "</book>"
};


CPPUNIT_TEST_SUITE_REGISTRATION(DOM_ParserWithNSTest);
