//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include "../src/MiX/EncodingResolver.h"

#define T_(str) MiX::XMLString<char>( str )

//CUPPA:namespace=+
//CUPPA:namespace=-

class GetEncodingTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(GetEncodingTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testSelect);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:
public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
   void testSelect() {
     const char data1[] = {
       "<?xml encoding=\"UTF-8\"?>"
       "<Library xmlns=\"library_url\" xmlns:html=\"html_url\">"
       "<Book>"
       "<Name>All your base vol.1</Name>"
       "<Price currency=\"yen\">5000</Price>"
       "<Description>are <html:strong>belong</html:strong> to us</Description>"
       "</Book>"
       "</Library>"
     };
     const char data2[] = {
       "<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>"
       "<!-- {gB -->"
       "<eXgX[c O=\"SAX_ParserTest\">"
       "<!-- ̓Rgł -->"
       "<eXgP[X O=\"testParse\"/>"
       "̃eLXgGg̓eXgp̕łB"
       "<![CDATA[CDATAZNVł!!]]>"
       "</eXgX[c>"
     };
     const char data3[] = "<?xml?>";
     const wchar_t data4[] = {
       L"<?xml version=\"1.0\" encoding=\"C++wchar_t\"?>"
       L"<!-- C++wchar_tǂ̕R[hɂȂ̂́A"
       L"nˑȂ̂ŁAC++wchar_tƂˋ̕R[ȟnƂĂ݂B-->"
       L"<Root/>"
     };
     // encoding͏ォ珇"UTF-8", "Shift_JIS", ""
     CPPUNIT_ASSERT_EQUAL( std::string("UTF-8"), 
			   MiX::getEncoding( data1, std::strlen(data1) ));
     CPPUNIT_ASSERT_EQUAL( std::string("Shift_JIS"), 
			   MiX::getEncoding( data2, std::strlen(data2) ));
     CPPUNIT_ASSERT_EQUAL( std::string(""), 
			   MiX::getEncoding( data3, std::strlen(data3) ));
     const char* data4_c = reinterpret_cast<const char*>(&data4[0]);
     CPPUNIT_ASSERT_EQUAL( std::string("C++wchar_t"), 
                           MiX::getEncoding( data4_c, MiX::generic_char_traits<wchar_t>::length(data4) ));
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(GetEncodingTest);
