//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include "../src/MiX/DOM_Parser.h"
#include "../src/MiX/Document.h"
#include "../src/MiX/Element.h"
#include "../src/MiX/Attribute.h"
#include "../src/MiX/Text.h"
#include "../src/MiX/XPath.h"

#define T_(str) MiX::XMLString<char>( str )

//CUPPA:namespace=+
//CUPPA:namespace=-

class XPathTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(XPathTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testSelect);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:
public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
   void testSelect() {
     const char data[] = {
       "<?xml?>"
       "<Library xmlns=\"library_url\" xmlns:html=\"html_url\">"
       "<Book>"
       "<Name>All your base vol.1</Name>"
       "<Price currency=\"yen\">5000</Price>"
       "<Description>are <html:strong>belong</html:strong> to us</Description>"
       "</Book>"
       "<Book>"
       "<Name>All your base vol.2</Name>"
       "<Price>10000</Price>"
       "<Description><html:i>are belong to us</html:i></Description>"
       "</Book>"
     };
     MiX::DOM_Parser<char> parser;
     MiX::Document<char>* doc = parser.parse(data);
     // (Ԥ㳰)
     MiX::XPath<char> path("Library/Book");
     // 쥯(Իưޤ̤ꡣ㳰NullResult)
     //MiX::XPathResult<char>& result = path( *doc );
     MiX::XPathResult<char> result = path( *doc );
     // resultθ
     CPPUNIT_ASSERT_EQUAL( MiX::Result_NodeList, result.getType() );
     CPPUNIT_ASSERT_EQUAL( (size_t)2, result.getNodeList().size() );
     /*CPPUNIT_ASSERT_EQUAL( T_("Book"), 
       dynamic_cast<Element*>(*result.getNodeList().begin())->getName() );*/
     // (Ԥ㳰)
     MiX::XPath<char> path2("Book/Price/@currency");
     // 쥯(Իưޤ̤ꡣ㳰NullResult)
     result = path2( doc->getRoot() );
     // resultθ
     CPPUNIT_ASSERT_EQUAL( MiX::Result_String, result.getType() );
     CPPUNIT_ASSERT_EQUAL( T_("yen"), result.getString() );
     delete doc;
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(XPathTest);
