// -*- mode: C++ -*-
#ifndef MiX_EncodingResolver_h_
#define MiX_EncodingResolver_h_

#include "classes.h"
#include "XMLString.h"
#include "Tokenizer.h"
#include "XMLToken.h" 
namespace MiX {
  /// from STLP
  template <class charT> 
  class generic_char_traits {
  public:
    typedef charT char_type;
    typedef const charT& const_char_ref;
    typedef const charT* const_char_ptr;
    typedef charT* char_ptr;
    
    typedef int int_type;
    typedef size_t size_type;

    typedef size_t pos_type;
    typedef size_t off_type;
    typedef char state_type;

    static void assign(char_type& c1, const char_type& c2) { c1 = c2; }
    static bool eq( const_char_ref c1, const_char_ref c2) { return c1 == c2; }
    static bool lt( const_char_ref c1, const_char_ref c2) { return c1 < c2; }
    static int compare( const_char_ptr s1, const_char_ptr s2, size_type n) {
      for (size_type i = 0; i < n; ++i)
	if (!eq(s1[i], s2[i])) return lt(s1[i],s2[i]) ? -1 : 1;
      return 0;
    }
    static size_t length(const_char_ptr s) {
      char_type null = char_type();
      size_type i;
      for (i = 0; !eq(s[i], null); ++i) ;
      return i;
    }
    static const_char_ptr find(const_char_ptr s, size_type n, const_char_ref c) {
      for ( ; n > 0 ; ++s, --n) if (eq(*s, c)) return s;
      return 0;
    }
    static char_ptr move( char_ptr s1, const_char_ptr s2, size_type n) {    
      return (n == 0 ? s1 : (char_ptr)memmove(s1, s2, n * sizeof(char_type)));
    }
  
    static char_ptr copy( char_ptr s1, const_char_ptr s2, size_type n) {    
      return (n == 0 ? s1 : (char_ptr)memcpy(s1, s2, n * sizeof(char_type)));
    }
    static char_ptr assign( char_ptr s, size_type n, char_type c) {
      for (size_type i = 0; i < n; ++i) s[i] = c;
      return s;
    }
    
    static int_type not_eof(const int_type& c) {
      return !eq_int_type(c, eof()) ? c : static_cast<int_type>(0);
    }
    static char_type to_char_type(const int_type& c) {
      return (char_type)c;
    }

    static int_type to_int_type(const char_type& c) {
      return (int_type)c;
    }    
    static bool eq_int_type(const int_type& c1, const int_type& c2) {
      return c1 == c2;
    }    
    static int_type eof() {
      return (int_type)-1;
    }
  };

  struct CharsetInfo {
    int width;
    bool le;
    int len;
  };

  /// \Kȗ\...
  inline CharsetInfo expectCharset( const char* data, int len ) {
    int zero_count = 0;
    const char* p = data;
    CharsetInfo ret;
    for( int i=0; i<len ; i++,p++ ) if( *p==0 ) zero_count++;
    if( zero_count==0 ) { //񒆂NULLoĂȂꍇAMultiByteB
      ret.width = 1;
      ret.len = len;
    } else if( zero_count<len/2+1 ) { 
      //񒆂0ȉ̏ꍇA2oCg̃ChB
      ret.width = 2;
      ret.len = len/2;
      // ToDo: 0xFF 0xFEĂꍇA
      //       D悷΂IオnY
      for( int i=0 ; i<len-1 ; i+=2, p+=2 ) {
	if( data[0]==0 ) {
	  ret.le = true;
	  break;
	} 
	if( data[1]==0 ) {
	  ret.le = false;
	  break;
	} 
      }      
    } else {
      //񒆂0ȏ̏ꍇA4oCg̃ChB
      ret.width = 4;
      ret.len = len/4;
      for( int i=0 ; i<len-1 ; i+=2, p+=2 ) {
	if( data[0]==0 ) {
	  ret.le = true;
	  break;
	} 
	if( data[3]==0 ) {
	  ret.le = false;
	  break;
	} 
      }
    }
    return ret;
  }

  template <class T>
  inline T* createBuffer( CharsetInfo info, const char* data ) {
    T* ret = new T[info.len+1];
    T* cur = ret;
    for( int i=0 ; i<info.len ; data+=info.width, ++i ) {
      *cur = 0;
      if( info.le ) {
	for( int j=0 ; j<info.width ; ++j ) {
	  *cur *= 256;
	  *cur += static_cast<T>(data[j]);
	}
      } else {
	for( int j=info.width-1 ; j>=0 ; --j ) {
	  *cur *= 256;
	  *cur += static_cast<T>(data[j]);
	}
      }
      cur++;
    }
    *cur = T();
    return ret;
  }

  // ̊֐inlineȂł邯ǁÅ֐̂߂ɊON̂
  // Ȃ̂inlineB
  inline std::string getEncoding( const char* data, int len ) {
    typedef unsigned long bigchar_t; // ǂȕ^ɂł\傫ȗeʂ^
    typedef XMLString<bigchar_t, generic_char_traits<bigchar_t> > bigstr_t;
    bigchar_t str_enc[] = {
      (bigchar_t)'e', (bigchar_t)'n', (bigchar_t)'c', (bigchar_t)'o',
      (bigchar_t)'d', (bigchar_t)'i', (bigchar_t)'n', (bigchar_t)'g',
      (bigchar_t) 0
    };
    CharsetInfo info = expectCharset( data, len );
    MiX::Tokenizer<bigchar_t, generic_char_traits<bigchar_t> > tokenizer;
    unsigned long *buf = createBuffer<unsigned long>( info, data );
    bigstr_t bigret;
    tokenizer.injectString( buf );
    XMLToken<bigchar_t, generic_char_traits<bigchar_t> > tok;
    do {
      tokenizer.ejectToken( tok );
      if( tok.getType()==Token_text ) {
	bigstr_t str = tok.getData();
	if( str==str_enc ) {
	  tokenizer.ejectToken( tok );
	  if( tok.getType()==Token_eq ) {
	    tokenizer.ejectToken( tok );
	    bigret.clear();
	    if( tok.getType()==Token_quote || tok.getType()==Token_dblquote ) {
	      tokenizer.ejectToken( tok );	      
	      while( tok.getType()!=Token_dblquote && 
		     tok.getType()!=Token_quote ) {
		bigret += tok.getData();
		tokenizer.ejectToken( tok );
	      } 
	      break;
	    } else tokenizer.pushToken( tok );
	  } else tokenizer.pushToken( tok );
	}
      }
    } while( tok.getType()!=Token_null );
    std::string ret;
    bigstr_t::iterator it = bigret.begin();
    bigstr_t::iterator last = bigret.end();
    for( ; it!=last ; ++it ) {
      ret += (char)(*it);
    }
    delete[] buf;
    return ret;
  }
}

#endif
