// -*- mode: C++ -*-
#ifndef MiX_XPath_h_
#define MiX_XPath_h_

#include "misc.h"
#include "classes.h"

namespace MiX {
  enum ResultType{
    Result_Null = 0,
    Result_NodeList,
    Result_Element = Result_NodeList,
    Result_Boolean,
    Result_Number,
    Result_String
  };

  template <class charT, class char_traits,class xml_traits>
  class XPathException : public std::exception{
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
  private:
    ErrorType type_;
    std::string what_;
  public:
    XPathException( ErrorType type, const std::string& what ) 
      : type_(type), what_(what) { }
    ~XPathException() throw() { }
    const char* what() const throw() { return what_.c_str(); }
    ErrorType getType() const throw() { return type_; }
  };

  template <class charT, class char_traits,class xml_traits>
  class XPathResult {
  public:
    MiX_Template_Typedef(charT, char_traits, xml_traits );
  private:
    union { 
      void* ptr_;
      nodelist_type* list_;
      bool* bool_;
      double* number_;
      string_type* str_;
    };
    ResultType type_;
  public:
    void assign( const xpathresult_type& src );
    void clear();
    XPathResult() : type_(Result_Null), ptr_(0) { }
    
    XPathResult( const nodelist_type& src ) : type_(Result_NodeList) {
      list_ = new nodelist_type();
      typename nodelist_type::const_iterator it = src.begin();
      typename nodelist_type::const_iterator last = src.end();
      for( ; it!=last ; ++it ) {
	list_->push_back( *it );
      }
    }
    XPathResult( bool src ) : type_(Result_Boolean), bool_(new bool(src)) { }
    XPathResult( double src ) : type_(Result_Number), number_(new double(src)) { }
    XPathResult( const string_type& src ) : type_(Result_String), str_(new string_type(src)) { }
    XPathResult( const xpathresult_type& src ) { assign( src ); }
    virtual ~XPathResult() { clear(); }
    xpathresult_type& operator=( const xpathresult_type& src ) { 
      clear( );
      assign( src );
    }
    ResultType getType() const { return type_; };
    /// ToDo: ^Cv`FbNƂقǂ
    nodelist_type& getNodeList() { return *list_; }
    const nodelist_type& getNodeList() const { return *list_; }
    element_type& getElement() { 
      typename nodelist_type::iterator it = list_->begin();
      typename nodelist_type::iterator last = list_->end();
      return dynamic_cast<element_type&>( **(list_->begin()) ); 
    }
    const element_type& getElement() const { 
      return dynamic_cast<const element_type&>( **(list_->begin()) ); 
    }
    bool getBoolean() const { return *bool_; }
    double getNumber() const { return *number_; }
    string_type& getString() { return *str_; }
    const string_type& getString() const { return *str_; }
    void output( std::ostream& os ) const;
  };

  template <class charT, class char_traits,class xml_traits>
  std::ostream& operator << ( std::ostream& os, const XPathResult<charT,char_traits,xml_traits>& obj ) {
    obj.output( os ); return os;
  }

  /**
   * XPath\NX
   */
  template <class charT, class char_traits,class xml_traits>
  class XPath {
  public:
    MiX_Template_Typedef(charT, char_traits, xml_traits );
  private:
    std::list<xpathatom_type*> atoms_;
  public:
    XPath( const string_type& src );
    virtual ~XPath() throw();
    xpathresult_type operator() ( nodecontainer_type& el ) { return execute(el); }
    xpathresult_type execute( nodecontainer_type& el );
  };
}

#ifndef MiX_XPath_cpp_
#include "XPath.cpp"
#endif

#endif
