#define MiX_XPathParser_cpp_

#include "XPathAtom.h"

namespace MiX{

  template <class charT,class char_traits,class xml_traits>
  XPathParser<charT,char_traits,xml_traits>::XPathParser( ) : src_() {
  }

  template <class charT,class char_traits,class xml_traits>
  void XPathParser<charT,char_traits,xml_traits>::parse( const string_type& src ) {
    src_ += src;
  }

  template <class charT,class char_traits,class xml_traits>
  XPathAtom<charT,char_traits,xml_traits>* XPathParser<charT,char_traits,xml_traits>::getNextAtom( ) {
    if( src_.length()==0 ) {
      /// B(ȗ`P[VpX͓WJĂn\Ȃ̂ŁA
      /// '//'̓G[B)
      /// ToDo: G[ǂ
      return 0;
    }
    int n = src_.find( xml_traits::slash() );
    string_type str;
    if( n==-1 ) {
      str = src_;
      src_.clear();
    } else {
      str = src_.substr( 0, n );
      src_ = src_.substr( n+1 );
    }
    if( str.at(0)==xml_traits::atmark() ) {
      /// Ag
      return new XPathAtom_Attribute<charT,char_traits,xml_traits>( str.substr(1) );
    } else {
      /// ZN^Ag
      return new XPathAtom_Selector<charT,char_traits,xml_traits>( str );
    }
    return 0;
  }
  
}

