#include <MiX/MiX.h>

#include <iostream>
#include <fstream>
#include <string>
#include <utility>

typedef std::map<std::string,std::string> PhoneBook;
typedef std::pair<std::string,std::string> Person;

std::string input(const char* prompt){
  std::string ret;
  std::cout << prompt << ": " << std::flush;
  std::cin >> ret;
  return ret;
}

char prompt(){
  std::string s = input("add/delete/find/list/clear/quit [a,d,f,l,c,q]");
  return s.at(0);
}

void outputPerson(const Person& per){
  std::cout << per.first << " : " << per.second << std::endl;
}

class EventHandler : public MiX::SAX_EventHandler<char>{
  PhoneBook& pb_;
  Person cur_;
  std::string str_;
public:
  EventHandler(PhoneBook& pb) : pb_(pb){
  }
  void onStart(MiX::XMLString<char> name,MiX::AttrMap<char> attr){
    str_="";
  }
  void onText(MiX::XMLString<char> text){
    str_+=text;
  }
  void onEnd(MiX::XMLString<char> name){
    if(name=="Person") pb_.insert(cur_);
    else if(name=="Name") cur_.first = str_;
    else if(name=="Phone") cur_.second = str_;
  }
};

void error(const char* errmsg){
  std::cout << "Error: " << errmsg << std::endl;
}

void storeFile(const char* fn,const PhoneBook& pb){
  std::ofstream fout(fn);
  fout << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" << std::endl
       << "<PhoneBook>";
  PhoneBook::const_iterator it = pb.begin();
  PhoneBook::const_iterator last = pb.end();
  for( ;it!=last;++it){
    fout << "\t<Person>" << std::endl
	 << "\t\t<Name>" << it->first << "</Name>" << std::endl
	 << "\t\t<Phone>" << it->second << "</Phone>" << std::endl
	 << "\t</Person>" << std::endl;
  }
  fout << "</PhoneBook>" << std::endl;
  fout.close();
}

int main(){
  PhoneBook pb;
  std::ifstream fin("phonebook.xml");
  if(fin.is_open()) {
    EventHandler handler(pb);
    MiX::SAX_Parser<char> parser;
    parser.setEventHandler(&handler);
    parser.setIgnoreSpace(true);
    parser.parse(fin);
  }
  char cmd = '\0';
  while(cmd!='q'){
    cmd = prompt();
    switch(cmd){
    case 'a' : case 'A' : {
      std::string name = input("Name");
      if(pb.find(name) != pb.end()) error("already exists.");
      else {
	std::string phone = input("Phone");
	pb.insert(Person(name,phone));
      }
      break;
    }
    case 'd' : case 'D' : {
      std::string name = input("Name");
      PhoneBook::iterator it =  pb.find(name);
      if(it==pb.end()) error("not found.");
      else pb.erase(it);
      break;
    }

    case 'f' : case 'F' : {
      std::string name = input("Name");
      PhoneBook::iterator it = pb.find(name);
      if(it==pb.end()) error("not found.");
      else outputPerson(*it);
      break;
    }
    case 'l' : case 'L' : {
      std::cout << pb.size() << "entries:" << std::endl;
	  std::for_each(pb.begin(),pb.end(),outputPerson);
      break;
    }
    case 'c' : case 'C' : {
      pb.clear();
      break;
    }
    // I
    case 'q' : case 'Q' : 
    default :
      break;
    }
  }
  storeFile("phonebook.xml",pb);
}
