#define MIX_ATTRIBUTE_CPP_

#include "Attribute.h"

namespace MiX{
  template <class charT,class traitsT>
  XMLString<charT,traitsT> Attribute<charT,traitsT>::toString(bool bIndent,int iIndentOffset)const{
    string_type s(getName());
    s += xml_traits::eq(); s += xml_traits::dblquote();
    s += getValue(); s += xml_traits::dblquote();
    return s;
  }
  
  template <class charT,class traitsT>
  Attribute<charT,traitsT>& Attribute<charT,traitsT>::create(const string_type& key,const string_type& val,nodecontainer_type& parent){
    this_type* newattr = new this_type(key,val);
    parent.getChildren().push_back(newattr);
    newattr->setParent(parent);
    return *newattr;
  }
  
}
