// -*- mode: c++ -*- 
#ifndef MIX_DOMEXCEPTION_H_
#define MIX_DOMEXCEPTION_H_

#include <exception>
#include "misc.h"
#include "classes.h"

namespace MiX{
  /**
   * DOMɎsɓO\NX
   *
   * G[Nm[hɑ΂
   */
  template <class charT,class traitsT>
  class DOM_Exception : public std::exception{
  public:
    MiX_Template_Typedef(charT,traitsT);
  private:
    const node_type* node_;
    ErrorType type_;
    std::string data_;
  public:
    ///RXgN^
    DOM_Exception(const node_type* node,ErrorType type,const std::string& data)
      : node_(node),type_(type),data_(data){ };
    ///fXgN^
    virtual ~DOM_Exception() throw(){ };
    ///G[̏ڍׂ킷Ԃ
    const char* what()const throw(){ return data_.c_str(); }
    ///G[NNodeւ̃|C^Ԃ
    const node_type* getNode()const throw(){ return node_; }
    ///G[^CvԂ
    ErrorType getType() const throw() { return type_; };
  };
}

#endif
