// -*- mode: c++ -*-

#ifndef MIX_NODECONTAINER_H_
#define MIX_NODECONTAINER_H_

#include "NodeList.h"
#include "Node.h"

namespace MiX{
  /**
   * qm[hێNode̊NX
   *
   * qm[hɊւANZXǗ
   */
  template <class charT,class traitsT>
  class NodeContainer : virtual public Node<charT,traitsT>{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef NodeContainer<charT,traitsT> this_type;
  protected:
    NodeList<charT,traitsT> children_;
    void addChild(node_type* node);
  protected:
    ///RXgN^
    NodeContainer() : node_type() { };
    /**
     * Rs[RXgN^
     *
     * NCAg͂ĂяoȂB܂Rs[łȂB
     */
    NodeContainer(const this_type& src){ };
  public:
    ///fXgN^
    virtual ~NodeContainer() throw();
    ///qm[h̃Xgւ̎QƂ𓾂܂
    nodelist_type& getChildren(){ return children_; };
    ///qm[h̃Xgւ̎QƂ𓾂܂(const)
    const nodelist_type& getChildren()const{ return children_; };
    ///Agr[g݂邩ǂ
    bool hasAttribute(const string_type& n);
    ///qGg𓾂܂
    element_type& getElement(const string_type& name,int index);
    ///qAgr[g𓾂܂
    attribute_type& getAttribute(const string_type& nm);
    /**
     * w肵OqGgAXgԂ܂
     *
     * \param tagname ^O
     */
    nodelist_type getElementsByTagName(const string_type& tagname);
    
    
#ifdef MiX_BACKWARD_COMPATIBILITY
    ///p炵݊
    nodelist_type& getChilds(){
      return getChildren();
    };
    ///p炵݊
    const nodelist_type& getChilds()const{
      return getChildren();
    }
#endif

    friend class DOM_Parser<charT,traitsT>;
  };
}

#ifndef MIX_NODECONTAINER_CPP_
#include "NodeContainer.cpp"
#endif

#endif
