// -*- mode: c++ -*- 
#ifndef __MIX_PARSINGEXCEPTION_H_
#define __MIX_PARSINGEXCEPTION_H_

#include <exception>
#include "misc.h"

namespace MiX{
  /**
   * DOM/SAXpParsing̗O\NX
   *
   * G[̋NCfbNXƁAG[̏ڍוƁAG[^Cv
   * B
   */
  class ParsingException : public std::exception{
    long index_;
    ErrorType type_;
    std::string data_;
  public:
    ///RXgN^
    ParsingException(long index,ErrorType type,const std::string& data) : index_(index),type_(type),data_(data){ };
    ///fXgN^
    virtual ~ParsingException() throw(){ };
    ///G[̏ڍׂ킷Ԃ
    const char* what()const throw(){ return data_.c_str(); };
    ///G[̋Nꏊ𕶎̐擪̃CfbNXŕԂ
    long getIndex()const{ return index_; };
    ///G[^CvԂ
    ErrorType getType()const{
      return type_;
    };
  };
}

#ifndef MIX_PARSINGEXCEPTION_CPP_
#include "ParsingException.cpp"
#endif

#endif
