// -*- mode: c++ -*-

#ifndef MIX_TOKENIZER_H_
#define MIX_TOKENIZER_H_


#include "classes.h"
#include "misc.h"
#include "XMLToken.h"

#include <stack>
#include <string>

namespace MiX{
  /**
   * ŗpg[NiCU
   *
   * g[N̈ӖlɂƂɂׂ؂蕪Ă
   * ӖlȂ̂ŁAʂ̕񒆂ɏoĂ'-'ƁA"<!--"
   * '-'𓯂g[NƂďo͂
   * SAX_Parser̊ȒPȏo͂Ӗ߂CxgN
   */
  template <class charT,class traitsT>
  class Tokenizer{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef Tokenizer<charT,traitsT> this_type;
    typedef XMLToken<charT,traitsT> token_type;
  private:
    const charT* data_;
    const charT* start_;
    const charT* current_;
    /**
     * Stream̉߂̎1si[Ăobt@
     * std::string::c_strœ|C^ۑĎgp̂́A
     * sȂ̂ŁARRɃRs[B
     */
    charT* line_;
    long len_;
    static const charT tokens_[15];
    std::stack<token_type> stack_;
    static TokenType isToken(charT);

    std::basic_istream<charT, char_traits>* is_;

    bool injectStringFromBuffer(const charT* text)
      { current_ = start_ = data_ = text; return true; }

    bool fillUpBuffer();
  public:
    ///RXgN^
    Tokenizer() : is_(0),line_(0) { }
    ///fXgN^
    ~Tokenizer(){ if(line_) delete line_; }
    ///g[NiCUɕ
    bool injectString(const charT* text)
      { current_ = start_ = data_ = text; return true; }
    ///g[NiCU̐擪ɂg[No
    bool ejectToken(token_type& dest);
    ///g[NiCU̐擪Ɏw肵g[N
    void pushToken(const token_type& tok){
      stack_.push(tok);
    }

    bool injectStream(std::basic_istream<charT, char_traits>& is)
      { is_ = &is; fillUpBuffer(); return true; }
  
  };

}

#ifndef MIX_TOKENIZER_CPP_
#include "Tokenizer.cpp"
#endif

#endif
