// -*- mode: C++ -*-
#ifndef MIX_XMLSTRING_H_
#define MIX_XMLSTRING_H_

#include <string>
#include <iosfwd>

#include "config.h"

namespace MiX{
  /**
   * i[NX
   *
   * basic_string<charT,traitsT::char_traits>ƂقړłA
   * XMLTraitsɃANZX邽߂typedef܂
   */
  template <class charT,class traitsT> 
  class XMLString
    : public std::basic_string<charT,typename traitsT::char_traits>{
    typedef std::basic_string<charT,typename traitsT::char_traits> super_type;
    typedef XMLString<charT,traitsT> this_type;
  public:
    ///RXgN^
    explicit XMLString() : super_type() { };
    ///RXgN^
    XMLString(const this_type& str) : super_type(str){ };
    ///RXgN^
    XMLString(const charT* s,size_t n) : super_type(s,n){ };
    ///RXgN^
    XMLString(const charT* s) : super_type(s){ };
    ///RXgN^
    XMLString(size_t n, char c) : super_type(n,c){ };
    ///RXgN^
    XMLString(const super_type& src) : super_type(src){ };
  };
  /// CT[^
  template <class charT,class traitsT>
  std::ostream& operator<<(std::ostream& os,const XMLString<charT,traitsT>& src);
}


#ifndef MIX_XMLSTRING_CPP_
#include "XMLString.cpp"
#endif

#endif
