#include "stdafx.h"
#include "resource.h"

#include <Exdisp.h>
#include <Mshtml.h>
#include <Shlguid.h>

#include "../lib/TemplateEvaluater.h"
#include "../lib/ScriptObject.h"

#include "Configuration.h"
#include "FileCreator.h"
#include "SettingDlg.h"
#include "Setting.h"
#include "HTMLElementFilter.h"
#include "StreamWriter.h"

/**
 * IẼc[j[ɓo^GNXeV̎łB
 * IÉAWXg񂩂ACOM𐶐
 * IOleCommandTargetC^[tFCXʂČĂяos܂B
 *
 * WXgɂ́ACOMIuWFNg̓o^ƁACOM
 * IEGNXeVƂēo^邽߂̃XNvg\[XuIDR_IEEXTENTIONv
 * LqĂ܂B
 */
class __declspec(uuid("{F58992D2-6DD8-4055-80A7-764B638935BA}")) CIEExtension
	: public CComObjectRoot
	, public CComCoClass<CIEExtension, &__uuidof(CIEExtension)>
	, public IObjectWithSiteImpl<CIEExtension>
	, public IOleCommandTarget
{
public:
	DECLARE_OBJECT_DESCRIPTION("MkImgPage IE Extension Object")

	BEGIN_COM_MAP(CIEExtension)
		COM_INTERFACE_ENTRY(IObjectWithSite)
		COM_INTERFACE_ENTRY(IOleCommandTarget)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_REGISTRY_RESOURCEID(IDR_IEEXTENSION)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		HRESULT hr;

		if ( !appTitle_.LoadString(IDS_APP_TITLE)) {
			return E_FAIL;
		}

		hr = GetTempFileCreator(&pFileCreator_);
		if (FAILED(hr)) {
			return hr;
		}

		return GetConfStrage(&pConfStrage_);
	}
	
	void FinalRelease() throw()
	{
	}

	virtual HRESULT __stdcall QueryStatus(
		const GUID *pguidCmdGroup, // Pointer to command group
		ULONG cCmds,               // Number of commands in prgCmds array
		OLECMD *prgCmds,           // Array of commands
		OLECMDTEXT *pCmdText       // Pointer to name or status of command
		) throw()
	{
		HRESULT hr = IsIdle();
		if (cCmds > 0) {
			for (ULONG idx = 0; idx < cCmds; idx++) {
				prgCmds[idx].cmdf = OLECMDF_SUPPORTED;
				if (hr == S_OK) {
					// y[W̓ǂݍ݂Ăꍇ̂
					// R}hI\ƂB
					prgCmds[idx].cmdf |= OLECMDF_ENABLED;
				}
			}
		}
		return S_OK;
	}

	virtual HRESULT __stdcall Exec(
		const GUID *pguidCmdGroup,  // Pointer to command group
		DWORD nCmdID,               // Identifier of command to execute
		DWORD nCmdExecOpt,          // Options for executing the command
		VARIANTARG *pvaIn,          // Pointer to input arguments
		VARIANTARG *pvaOut          // Pointer to command output
		) throw()
	{
		HRESULT hr;
		try {
			// uEU̎擾
			CComPtr<IWebBrowser2> pBrowser;
			hr = GetBrowser(&pBrowser);
			if (FAILED(hr)) AtlThrow(hr);

			HWND hWnd = NULL;
			hr = pBrowser->get_HWND((SHANDLE_PTR*)&hWnd);
			if (FAILED(hr) || hWnd == NULL) {
				hWnd = ::GetActiveWindow();
			}

			try {
				// y[W̓ǂݍ݂ĂȂꍇ͐ɐi܂ȂB
				// (R}hs܂ŁAQueryStatus͌ĂяoȂ߁B)
				hr = IsIdle();
				if (FAILED(hr)) AtlThrow(hr);

				if (hr == S_FALSE) {
					CString mes;
					mes.LoadString(IDS_BROWSER_BUSY);
					::MessageBox(hWnd, mes, appTitle_, MB_ICONINFORMATION | MB_OK);
					return S_FALSE;
				}

				// hLg̎擾
				CComPtr<IDispatch> pDocDisp;
				hr = pBrowser->get_Document(&pDocDisp);
				if (FAILED(hr)) AtlThrow(hr);

				CComPtr<IHTMLDocument2> pDoc;
				hr = pDocDisp.QueryInterface(&pDoc);
				if (FAILED(hr)) AtlThrow(hr);

				// x[X̎擾
				CComBSTR baseURL;
				hr = GetDocumentBase(pDoc, &baseURL);
				if (FAILED(hr)) AtlThrow(hr);

				// ݒ̕
				CComPtr<ISetting> pSetting;
				hr = CreateSetting(&pSetting);
				if (FAILED(hr)) AtlThrow(hr);

				CComQIPtr<IPersistConf> pPersistConf(pSetting);
				hr = pPersistConf->Load(pConfStrage_);
				if (FAILED(hr)) {
					CString fmt;
					CString msg;
					fmt.LoadString(IDS_ERROR_LOADSETTINGS);
					msg.Format(fmt, hr);
					::MessageBox(hWnd, msg, appTitle_, MB_ICONWARNING | MB_OK);
					// ǂݍ݂ɎsĂs
				}

				// URL~b^̐ݒ
				pSetting->put_URL_Limit(baseURL);

				// _CAO̕\
				CSettingDlg dlg;
				dlg.SetSetting(pSetting);
				const INT_PTR ret = dlg.DoModal(hWnd);
				if (ret != IDOK) {
					// LZ
					return S_FALSE;
				}

				// ݒ̕ۑ
				if (pPersistConf->IsDirty() == S_OK) {
					hr = pPersistConf->Save(pConfStrage_);
					if (FAILED(hr)) {
						CString fmt;
						CString msg;
						fmt.LoadString(IDS_ERROR_SAVESETTINGS);
						msg.Format(fmt, hr);
						::MessageBox(hWnd, msg, appTitle_, MB_ICONWARNING | MB_OK);
					}
				}

				// tB^̎sƌʂ̎擾
				CComPtr<IScriptObject> pResultObject;
				hr = DoFilter(pDoc, pSetting, &pResultObject);
				if (FAILED(hr)) AtlThrow(hr);

				// \ڐ̐
				hr = CheckPerformanceGuard(hWnd, pResultObject);
				if (hr != S_OK) {
					return S_OK;
				}

				// ǉ̏̐ݒ
				hr = pResultObject->put_item(
					CComVariant(L"baseLocation"), CComVariant(baseURL));
				if (FAILED(hr)) AtlThrow(hr);
				hr = pResultObject->put_item(
					CComVariant(L"document"), CComVariant(pDoc));
				if (FAILED(hr)) AtlThrow(hr);

				CComPtr<IScriptObject> pConfigObject;
				hr = CreateScriptObject(&pConfigObject);
				if (FAILED(hr)) AtlThrow(hr);
				UINT iframeWidth;
				UINT iframeHeight;
				hr = pSetting->get_IFrame_Width(&iframeWidth);
				if (FAILED(hr)) AtlThrow(hr);
				hr = pSetting->get_IFrame_Height(&iframeHeight);
				if (FAILED(hr)) AtlThrow(hr);
				hr = pConfigObject->put_item(
					CComVariant(L"iframeWidth"), CComVariant(iframeWidth));
				if (FAILED(hr)) AtlThrow(hr);
				hr = pConfigObject->put_item(
					CComVariant(L"iframeHeight"), CComVariant(iframeHeight));
				if (FAILED(hr)) AtlThrow(hr);
				pResultObject->put_item(
					CComVariant("config"), CComVariant(pConfigObject));
				if (FAILED(hr)) AtlThrow(hr);

				// o͐t@C̍쐬
				CComPtr<IFileName> pFileName;
				hr = pFileCreator_->Create(&pFileName);
				if (FAILED(hr)) AtlThrow(hr);

				CComPtr<IStream> pStm;
				hr = pFileName->GetStream(&pStm);
				if (FAILED(hr)) AtlThrow(hr);

				// ʃt@C̍쐬
				CComBSTR errorMessage;
				hr = MakeResultDocument(pResultObject, pStm, &errorMessage);
				if (FAILED(hr)) {
					if (errorMessage) {
						// XNvgGW̃G[bZ[W̕\
						::MessageBox(
							hWnd,
							CW2T(errorMessage),
							appTitle_,
							MB_ICONERROR | MB_OK
							);
						return hr;
					}
					AtlThrow(hr);
				}

				pStm.Release();

				// uEUɕ\
				CComBSTR filePath;
				hr = pFileName->get_Path(&filePath);
				if (FAILED(hr)) AtlThrow(hr);

				CComVariant targetURL(filePath);
				CComVariant targetWindow;
				CComVariant flags;
				if (pSetting->is_OpenNewWindow() == S_OK) {
					targetWindow = L"_blank";
					flags = navOpenInNewWindow;
				}
				else {
					targetWindow = L"_top";
					flags = 0;
				}
				CComVariant postData, headers;

				hr = pBrowser->Navigate2(
					&targetURL,
					&flags,
					&targetWindow,
					&postData,
					&headers
					);
				if (FAILED(hr)) AtlThrow(hr);

				return S_OK;
			}
			catch (const CAtlException& exception) {
				CString fmt;
				CString message;
				fmt.LoadString(IDS_ERROR_HRESULT);
				message.Format(fmt, exception.m_hr);
				::MessageBox(hWnd, message, appTitle_, MB_ICONERROR | MB_OK);
				return S_OK;
			}
		}
		catch (...) {
			CString fmt;
			fmt.LoadString(IDS_ERROR_UNKNOWN);
			::MessageBox(NULL, fmt, appTitle_, MB_ICONERROR | MB_OK);
			return S_OK;
		}
	}

	HRESULT CheckPerformanceGuard(HWND v_hWnd, IScriptObject* v_pScriptObject)
	{
		ATLASSERT(v_pScriptObject);

		HRESULT hr;
		
		CComVariant varIFrames;
		hr = v_pScriptObject->get_item(CComVariant("iframe"), &varIFrames);
		if (FAILED(hr)) {
			ATLASSERT(false);
			return hr;
		}
		hr = varIFrames.ChangeType(VT_DISPATCH);
		if (FAILED(hr)) {
			ATLASSERT(false);
			return hr;
		}

		CComQIPtr<IScriptObject> pFrames(varIFrames.pdispVal);
		ATLASSERT(pFrames);

		long len;
		hr = pFrames->get_length(&len);
		if (FAILED(hr)) return hr;

		DWORD mx;
		hr = pConfStrage_->GetDWORD(L"MAX_IFRAME", 20, &mx);
		if (FAILED(hr)) return hr;

		if ((long) mx >= len) {
			return S_OK;
		}

		CString fmt;
		CString msg;
		fmt.LoadString(IDS_WARNING_TOOMANY_IFRAMES);
		msg.Format(fmt, len, mx);

		int ret = ::MessageBox(v_hWnd, msg, appTitle_, MB_ICONWARNING | MB_YESNO);

		return (ret == IDYES) ? S_OK : S_FALSE;
	}

	/**
	 * oʂt@CɏށB
	 * G[bZ[W擾ꂽꍇAG[bZ[W̊i[|C^ɃZbg܂B
	 * @param v_pScriptObject o
	 * @param v_pOutputStm o͐
	 * @param v_pErrorMessage G[bZ[Wi[|C^
	 * @return HR
	 */
	HRESULT MakeResultDocument(IScriptObject* v_pScriptObject, IStream* v_pOutputStm, BSTR* v_pErrorMessage)
	{
		ATLASSERT(v_pScriptObject);
		ATLASSERT(v_pOutputStm);
		ATLASSERT(v_pErrorMessage);

		TCHAR szFilePath[MAX_PATH];
		DWORD dwFLen = ::GetModuleFileName(
			_AtlBaseModule.GetModuleInstance(), szFilePath, MAX_PATH);
		if( dwFLen == 0 || dwFLen == MAX_PATH ) {
			// W[̃pX̎擾Ɏs
			return E_FAIL;
		}

		LPTSTR p = szFilePath;
		while (*p) p++;
		while (p > szFilePath) {
			if (*p == '\\') {
				*p = 0;
				break;
			}
			p = CharPrev(szFilePath, p);
		}
		if (*p) {
			ATLASSERT(false);
			return E_FAIL;
		}

		CComBSTR templPath(szFilePath);
		templPath += L"\\template.html"; // IƂ͂Ȃ

		HRESULT hr;

		CComPtr<IScriptBuilder> pScriptBuilder;
		hr = CreateScriptBuilder(__uuidof(VBScript), &pScriptBuilder);
		if (FAILED(hr)) return hr;

		CComPtr<ITemplateSourceChunkBuilder> pChunkBuilder;
		hr = CreateTemplateSourceChunkBuilder(&pChunkBuilder);
		if (FAILED(hr)) return hr;

		CComPtr<ITemplateSourceProcessor> pChunkWriterProcessor;
		hr = CreateTemplateSourceEncodingProcessor(pScriptBuilder, &pChunkWriterProcessor);
		if (FAILED(hr)) return hr;

		hr = pChunkBuilder->RegisterProcessor(pChunkWriterProcessor);
		if (FAILED(hr)) return hr;

		CComPtr<ITemplateSourceSplitter> pReader;
		hr = CreateTemplateSourceSplitter(pChunkBuilder, &pReader);
		if (FAILED(hr)) return hr;

		CComPtr<IStream> pStm;
		hr = SHCreateStreamOnFile(
			templPath,
			STGM_READ | STGM_SHARE_DENY_WRITE,
			&pStm);
		if (FAILED(hr)) return hr;

		hr = pReader->Parse(pStm);
		if (FAILED(hr)) return hr;
		pStm.Release();

		hr = pScriptBuilder->SetOutputStream(v_pOutputStm);
		if (FAILED(hr)) return hr;

		hr = pScriptBuilder->RegistExternalObject(L"ext", v_pScriptObject);
		if (FAILED(hr)) return hr;

		hr = pScriptBuilder->Execute(v_pErrorMessage);
		if (FAILED(hr)) return hr;

		return S_OK;
	}

	/**
	 * hLgx[X擾B
	 * hLgɃx[Xvf΁ApB
	 * ݂Ȃ
	 */
	HRESULT GetDocumentBase(IHTMLDocument2* v_pDoc, BSTR* v_pBaseURL)
	{
		ATLASSERT(v_pDoc);
		ATLASSERT(v_pBaseURL);
		ATLASSERT( !*v_pBaseURL);

		HRESULT hr;

		CComPtr<IHTMLElementCollection> pAll;
		hr = v_pDoc->get_all(&pAll);
		if (FAILED(hr)) AtlThrow(hr);

		CComPtr<IDispatch> pBaseDisp;
		hr = pAll->tags(CComVariant(L"base"), &pBaseDisp);
		if (FAILED(hr)) AtlThrow(hr);
		CComQIPtr<IHTMLElementCollection> pBaseTags(pBaseDisp);
		long baseTagsCnt;
		hr = pBaseTags->get_length(&baseTagsCnt);
		if (FAILED(hr)) AtlThrow(hr);

		CComBSTR baseURL;
		if (baseTagsCnt > 0) {
			CComVariant idx(0);
			CComVariant dmy;
			CComPtr<IDispatch> pBaseTagDisp;
			hr = pBaseTags->item(idx, dmy, &pBaseTagDisp);
			if (FAILED(hr)) AtlThrow(hr);
			CComQIPtr<IHTMLBaseElement> pBaseTag(pBaseTagDisp);
			hr = pBaseTag->get_href(&baseURL);
			if (FAILED(hr)) AtlThrow(hr);

			if (baseURL && baseURL.Length() == 0) {
				baseURL.Empty();
			}
		}
		if ( !baseURL) {
			// x[Xw肳ĂȂ΁ÃhLg̃P[Vgp
			if (FAILED(v_pDoc->get_URL(&baseURL)) || baseURL == NULL) {
				baseURL = L"";
			}
		}

		*v_pBaseURL = baseURL.Detach();
		return S_OK;
	}

	/**
	 * ݒɊÂăhLg烊N𒊏oAʂ擾B
	 * @param v_pDoc hLg
	 * @param v_pSetting ݒ
	 * @param v_ppResultObject ʂi[ꂽIuWFNgi[|C^
	 * @return HR
	 */
	HRESULT DoFilter(IHTMLDocument2* v_pDoc, ISetting* v_pSetting, IScriptObject** v_ppResultObject)
	{
		ATLASSERT(v_pDoc);
		ATLASSERT(v_pSetting);
		ATLASSERT(v_ppResultObject);

		HRESULT hr;

		// tB^ݒ̍\z
		CComPtr<ISettingAcceptors> pSettingAcceptors;
		hr = CreateSettingAcceptors(v_pSetting, &pSettingAcceptors);
		if (FAILED(hr)) {
			AtlThrow(hr);
		}

		// HTMLvftB^̍\z
		CComPtr<IHTMLElementFilter> pHTMLElementFilter;
		hr = CreateHTMLElementFilter(&pHTMLElementFilter);
		if (FAILED(hr)) {
			AtlThrow(hr);
		}
		hr = pHTMLElementFilter->put_Setting(pSettingAcceptors);
		if (FAILED(hr)) {
			AtlThrow(hr);
		}

		// tB^̎s
		hr = pHTMLElementFilter->DoFilter(v_pDoc);
		if (FAILED(hr)) {
			AtlThrow(hr);
		}

		return pHTMLElementFilter->GetCollection(v_ppResultObject);
	}

	/**
	 * SiteuEU擾B
	 * 擾łȂꍇ̓G[R[hԂB
	 */
	HRESULT GetBrowser(IWebBrowser2** ppBrowser) throw()
	{
		if ( !ppBrowser) {
			return E_POINTER;
		}
		try {
			if ( !m_spUnkSite) {
				return E_FAIL;
			}

			HRESULT hr;

			CComPtr<IServiceProvider> pServiceProvider;
			hr = m_spUnkSite.QueryInterface(&pServiceProvider);
			if (FAILED(hr)) return hr;

			CComPtr<IServiceProvider> pTopLevelBrowser;
			hr = pServiceProvider->QueryService(SID_STopLevelBrowser, &pTopLevelBrowser);
			if (FAILED(hr)) return hr;

			hr = pTopLevelBrowser->QueryService(SID_SWebBrowserApp, ppBrowser);
			if (FAILED(hr)) return hr;

			return S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	/**
	 * uEUAChł邩`FbNB
	 * uEUAChłS_OKAłȂS_FALSEԂB
	 * uEUɃANZXłȂꍇ̓G[R[hԂB
	 */
	HRESULT IsIdle() throw()
	{
		try {
			HRESULT hr;
			CComPtr<IWebBrowser2> pBrowser;
			hr = GetBrowser(&pBrowser);
			if (FAILED(hr)) return hr;
			
			VARIANT_BOOL busy;
			hr = pBrowser->get_Busy(&busy);
			if (FAILED(hr)) return hr;

			return (busy == VARIANT_TRUE) ? S_FALSE : S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

protected:

	CString appTitle_;

	CComPtr<IConfStrage> pConfStrage_;

	CComPtr<IFileCreator> pFileCreator_;
};

OBJECT_ENTRY_AUTO(__uuidof(CIEExtension), CIEExtension);
