#include "stdafx.h"
#include "resource.h"

#include <htmlhelp.h>
#include <shellapi.h>

#include "SettingDlg.h"

CSettingDlg::CSettingDlg(void)
{
}

CSettingDlg::~CSettingDlg(void)
{
}

HRESULT CSettingDlg::SetSetting(ISetting* v_pSetting) throw()
{
	ATLASSERT(v_pSetting);
	try {
		pSetting_ = v_pSetting;
		return S_OK;
	}
	catch (...) {
		return E_FAIL;
	}
}

HRESULT CSettingDlg::GetSetting(ISetting** v_ppSetting) throw()
{
	if ( !pSetting_) {
		*v_ppSetting = NULL;
		return S_FALSE;
	}

	return pSetting_.CopyTo(v_ppSetting);
}

void CSettingDlg::UpdateAllItems(void) throw()
{
	ATLASSERT(pSetting_);

	CheckDlgButton(IDC_IMG_LINK,
		(pSetting_->is_ImgLink() == S_OK) ? BST_CHECKED : BST_UNCHECKED);
	
	CComBSTR tmp;
	if (SUCCEEDED(pSetting_->get_ImgLink_Ext(&tmp))){
		SetDlgItemText(IDC_IMG_LINK_EXT, CW2T(tmp));
	}
	
	CheckDlgButton(IDC_IMG,
		(pSetting_->is_Img() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	tmp.Empty();
	if (SUCCEEDED(pSetting_->get_Img_Ext(&tmp))) {
		SetDlgItemText(IDC_IMG_EXT, CW2T(tmp));
	}

	CheckDlgButton(IDC_IMG_SIZE,
		(pSetting_->is_Img_Size() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	UINT imgWidth;
	if (SUCCEEDED(pSetting_->get_Img_Width(&imgWidth))) {
		CString strImgWidth;
		strImgWidth.Format(_TEXT("%lu"), imgWidth);
		SetDlgItemText(IDC_IMG_WIDTH, strImgWidth);
	}

	UINT imgHeight;
	if (SUCCEEDED(pSetting_->get_Img_Height(&imgHeight))) {
		CString strImgHeight;
		strImgHeight.Format(_TEXT("%lu"), imgHeight);
		SetDlgItemText(IDC_IMG_HEIGHT, strImgHeight);
	}

	CheckDlgButton(IDC_URL_LINK,
		(pSetting_->is_URLLink() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	tmp.Empty();
	if (SUCCEEDED(pSetting_->get_URLLink_Ext(&tmp))) {
		SetDlgItemText(IDC_URL_LINK_EXT, CW2T(tmp));
	}

	UINT frmWidth;
	if (SUCCEEDED(pSetting_->get_IFrame_Width(&frmWidth))) {
		CString strFrmWidth;
		strFrmWidth.Format(_TEXT("%lu"), frmWidth);
		SetDlgItemText(IDC_IFRAME_WIDTH, strFrmWidth);
	}

	UINT frmHeight;
	if (SUCCEEDED(pSetting_->get_IFrame_Height(&frmHeight))) {
		CString strFrmHeight;
		strFrmHeight.Format(_TEXT("%lu"), frmHeight);
		SetDlgItemText(IDC_IFRAME_HEIGHT, strFrmHeight);
	}

	CheckDlgButton(IDC_LINK,
		(pSetting_->is_Link() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	tmp.Empty();
	if (SUCCEEDED(pSetting_->get_Link_Ext(&tmp))) {
		SetDlgItemText(IDC_LINK_EXT, CW2T(tmp));
	}

	CheckDlgButton(IDC_URL,
		(pSetting_->is_URL() == S_OK) ? BST_CHECKED : BST_UNCHECKED);

	tmp.Empty();
	if (SUCCEEDED(pSetting_->get_URL_Limit(&tmp))) {
		SetDlgItemText(IDC_URL_LIMIT, CW2T(tmp));
	}

	CheckDlgButton(IDC_OPEN_NEW,
		(pSetting_->is_OpenNewWindow() == S_OK) ? BST_CHECKED : BST_UNCHECKED);
}

LRESULT CSettingDlg::OnInitDialog(UINT uMsg,
	WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	HMENU hSysMenu = GetSystemMenu(FALSE);
	ATLASSERT(hSysMenu);

	CString menuText;
	if ( !menuText.LoadString(IDS_SYSCMD_HELP)) {
		ATLASSERT(false);
	}
	LPTSTR lpMenuText = menuText.GetBuffer();

	MENUITEMINFO menuItemInfo = {0};
	menuItemInfo.cbSize = sizeof(MENUITEMINFO);
	menuItemInfo.fMask = MIIM_STRING | MIIM_ID;
	menuItemInfo.fType = MFT_STRING;
	menuItemInfo.dwTypeData = lpMenuText;
	menuItemInfo.cch = lstrlen(lpMenuText);
	menuItemInfo.wID = IDC_SYSCMD_ABOUT;
	InsertMenuItem(hSysMenu, SC_CLOSE, FALSE, &menuItemInfo);

	UpdateAllItems();
	return 0;
}

LRESULT CSettingDlg::OnSysCommand(UINT uMsg,
	WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	if (wParam != IDC_SYSCMD_ABOUT) {
		bHandled = FALSE;
		return 0;
	}

	CString url;
	url.LoadString(IDS_SYSCMD_HELP_URL);

	ShellExecute(m_hWnd, _TEXT("OPEN"), url, NULL, NULL, SW_SHOWNORMAL);

	return 0;
}


LRESULT CSettingDlg::OnHelp(UINT uMsg,
	WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	HELPINFO *pHelpInfo = (HELPINFO*) lParam;

	CString message;
	if (!message.LoadString(pHelpInfo->iCtrlId)) {
		message.LoadString(IDS_NO_HELP);
	}

	RECT margin = {8, 8, 8, 8};

	HH_POPUP popupInfo = {0};
	popupInfo.cbStruct = sizeof(HH_POPUP);
	popupInfo.idString = 0;
	popupInfo.pszText = message;
	popupInfo.pt = pHelpInfo->MousePos;
	popupInfo.clrForeground = -1;
	popupInfo.clrBackground = -1;
	popupInfo.rcMargins = margin;

	if ( !HtmlHelp(m_hWnd, NULL, HH_DISPLAY_TEXT_POPUP, (DWORD_PTR) &popupInfo)) {
		MessageBox(_TEXT("wv݂܂B"));
	}

	return 0;
}

LRESULT CSettingDlg::OnOK(
	WORD wNotifyCode,
	WORD wID,
	HWND hWndCtl,
	BOOL& bHandled 
	)
{
	ATLASSERT(pSetting_);

	CComBSTR tmp;
	CString sizTemp;

	pSetting_->put_ImgLink(IsDlgButtonChecked(IDC_IMG_LINK) == BST_CHECKED);

	if (GetDlgItemText(IDC_IMG_LINK_EXT, tmp.m_str)) {
		pSetting_->put_ImgLink_Ext(tmp);
	}

	pSetting_->put_Img(IsDlgButtonChecked(IDC_IMG) == BST_CHECKED);

	if (GetDlgItemText(IDC_IMG_EXT, tmp.m_str)) {
		pSetting_->put_Img_Ext(tmp);
	}

	pSetting_->put_Img_Size(IsDlgButtonChecked(IDC_IMG_SIZE) == BST_CHECKED);

	if (GetDlgItemText(IDC_IMG_WIDTH, sizTemp)) {
		const UINT siz = _ttol(sizTemp);
		pSetting_->put_Img_Width(siz);
	}
	if (GetDlgItemText(IDC_IMG_HEIGHT, sizTemp)) {
		const UINT siz = _ttol(sizTemp);
		pSetting_->put_Img_Height(siz);
	}

	pSetting_->put_URLLink(IsDlgButtonChecked(IDC_URL_LINK) == BST_CHECKED);

	if (GetDlgItemText(IDC_URL_LINK_EXT, tmp.m_str)) {
		pSetting_->put_URLLink_Ext(tmp);
	}

	if (GetDlgItemText(IDC_IFRAME_WIDTH, sizTemp)) {
		const UINT siz = _ttol(sizTemp);
		pSetting_->put_IFrame_Width(siz);
	}
	if (GetDlgItemText(IDC_IFRAME_HEIGHT, sizTemp)) {
		const UINT siz = _ttol(sizTemp);
		pSetting_->put_IFrame_Height(siz);
	}

	pSetting_->put_Link(IsDlgButtonChecked(IDC_LINK) == BST_CHECKED);

	if (GetDlgItemText(IDC_LINK_EXT, tmp.m_str)) {
		pSetting_->put_Link_Ext(tmp);
	}

	pSetting_->put_URL(IsDlgButtonChecked(IDC_URL) == BST_CHECKED);

	if (GetDlgItemText(IDC_URL_LIMIT, tmp.m_str)) {
		pSetting_->put_URL_Limit(tmp);
	}

	pSetting_->put_OpenNewWindow(IsDlgButtonChecked(IDC_OPEN_NEW) == BST_CHECKED);

	EndDialog(IDOK);
	return 0;
}

LRESULT CSettingDlg::OnCancel(
	WORD wNotifyCode,
	WORD wID,
	HWND hWndCtl,
	BOOL& bHandled 
	)
{
	EndDialog(IDCANCEL);
	return 0;
}

LRESULT CSettingDlg::OnBnClickedReset(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	ATLASSERT(pSetting_);

	// ݒlɖ߂
	DWORD keyState = GetKeyState(VK_SHIFT);
	if (keyState & 0x8000) {
		try {
			HRESULT hr;

			CComBSTR urlLimit;
			hr = pSetting_->get_URL_Limit(&urlLimit);

			CComQIPtr<IPersistConf> pPersistConf(pSetting_);
			pPersistConf->InitNew();

			if (SUCCEEDED(hr)) {
				pSetting_->put_URL_Limit(urlLimit);
			}
		}
		catch (...) {
			MessageBox(_TEXT("sȗO܂B"), _TEXT("G["), MB_ICONERROR | MB_OK);
			return 0;
		}
	}

	// _CAOĐݒ肷
	UpdateAllItems();

	return 0;
}
