#include "stdafx.h"

#include "NameAcceptor.h"

HRESULT __stdcall ConfigureMultiPatternNameAcceptor(LPCWSTR v_pArgs, IMultiNameAcceptor* v_pNameAcceptor) throw()
{
	if ( !v_pNameAcceptor) {
		return E_INVALIDARG;
	}

	if ( !v_pArgs) {
		return S_FALSE;
	}

	try {
		int appendCount = 0;
		LPCWSTR p = v_pArgs;
		while (*p) {
			// s؂蕶XLbv
			while (*p == ' ' || *p == '\t' || *p == '\r' || *p == '\n' || *p == ';') p++;
			LPCWSTR pSt = p;
			
			// ؂蕶܂Ői߂
			while (*p && *p != ' ' && *p != '\t' && *p != '\r' && *p != '\n' && *p != ';') {
				p = CharNext(p);
			}
			LPCWSTR pEn = p;
			
			// ꂽ͈͂؂o
			int len = static_cast<int>(pEn - pSt);
			if (len > 0) {
				CComBSTR name(len, pSt);

				// PatternNameAcceptor쐬o^B
				HRESULT hr;
				CComPtr<INameAcceptor> pPatternNameAcceptor;
				hr = CreatePatternNameAcceptor(name, &pPatternNameAcceptor);
				if (FAILED(hr)) {
					return hr;
				}

				hr = v_pNameAcceptor->Add(pPatternNameAcceptor);
				if (FAILED(hr)) {
					return hr;
				}

				appendCount++;
			}
		}

		return (appendCount > 0) ? S_OK : S_FALSE;
	}
	catch (...) {
		return E_FAIL;
	}
}
