#include "stdafx.h"

#include <activscp.h>

#include "TemplateEvaluater.h"

#include "SimpleBuffer.h"

/**
 * eo͂邽߂̕⏕NXB
 * IDispatchƂČĂяoꂽꍇAe܂͈̂̂o͂܂B
 */
class __declspec(uuid("{71412BDD-1BE5-4c47-9707-55A8125C5527}")) CLiteralDispatchImpl
	: public CComObjectRoot
	, public IDispatch
{
public:
	BEGIN_COM_MAP(CLiteralDispatchImpl)
		COM_INTERFACE_ENTRY(IDispatch)
	END_COM_MAP()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT SetWriter(ITemplateSourceWriter2* v_pOutput) throw()
	{
		try {
			pOutput_ = v_pOutput;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	HRESULT GetWriter(ITemplateSourceWriter2** v_ppOutput) throw()
	{
		return pOutput_.CopyTo(v_ppOutput);
	}

	void Reset()
	{
		literals_.RemoveAll();
	}

	ULONG AddLiteral(LPCWSTR v_pLine, UINT v_siz)
	{
		size_t idx = literals_.Add();

		if (v_pLine && v_siz > 0) {
			CAtlStringW& line = literals_.GetAt(idx);
			line.Append(v_pLine, v_siz);
		}

		return static_cast<ULONG>(idx);
	}

	//////

	virtual HRESULT __stdcall GetTypeInfoCount( 
        /* [out] */ UINT *pctinfo)
	{
		if ( !pctinfo) {
			return E_INVALIDARG;
		}
		*pctinfo = 0;
		return S_OK;
	}
    
    virtual HRESULT __stdcall GetTypeInfo( 
        /* [in] */ UINT iTInfo,
        /* [in] */ LCID lcid,
        /* [out] */ ITypeInfo **ppTInfo)
	{
		return TYPE_E_ELEMENTNOTFOUND;
	}
    
    virtual HRESULT __stdcall GetIDsOfNames( 
        /* [in] */ REFIID riid,
        /* [size_is][in] */ LPOLESTR *rgszNames,
        /* [in] */ UINT cNames,
        /* [in] */ LCID lcid,
        /* [size_is][out] */ DISPID *rgDispId)
	{
		if ( !rgszNames) {
			return E_INVALIDARG;
		}

		try {
			bool unknown = false;
			for (UINT idx = 0; idx < cNames; idx++) {
				LPOLESTR szName = rgszNames[idx];
				if ( !szName) {
					return E_INVALIDARG;
				}
				CComBSTR name(szName);
				if (FAILED(name.ToLower())) {
					return E_FAIL;
				}

				if (name == L"write") {
					// write\bh
					rgDispId[idx] = DISPID_VALUE;
				}
				else if (name == L"writeliteral") {
					// write\bh
					rgDispId[idx] = 1;
				}
				else {
					// sȖO
					unknown = true;
					rgDispId[idx] = DISPID_UNKNOWN;
				}
			}

			if (unknown) {
				return DISP_E_UNKNOWNNAME;
			}
			return S_OK;
		}
		catch (const CAtlException& err) {
			return err.m_hr;
		}
		catch (...) {
			return E_FAIL;
		}
	}
    
    virtual /* [local] */ HRESULT __stdcall Invoke( 
        /* [in] */ DISPID dispIdMember,
        /* [in] */ REFIID riid,
        /* [in] */ LCID lcid,
        /* [in] */ WORD wFlags,
        /* [out][in] */ DISPPARAMS *pDispParams,
        /* [out] */ VARIANT *pVarResult,
        /* [out] */ EXCEPINFO *pExcepInfo,
        /* [out] */ UINT *puArgErr)
	{
		if (dispIdMember != DISPID_VALUE && dispIdMember != 1) {
			// sDISPID
			return DISP_E_MEMBERNOTFOUND;
		}
		if ( !(wFlags & DISPATCH_METHOD)) {
			// \bhĂяoȊO
			return DISP_E_MEMBERNOTFOUND;
		}
		if (pDispParams->cArgs < 1) {
			// K{p[^Ȃ
			return DISP_E_PARAMNOTOPTIONAL;
		}

		if ( !pOutput_) {
			// o͐悪w肳ĂȂB
			ATLASSERT(false);
			return E_FAIL;
		}

		HRESULT hr;

		if (dispIdMember == DISPID_VALUE) {
			// write\bh
			CComVariant param;
			hr = param.ChangeType(VT_BSTR, &(pDispParams->rgvarg[0]));
			if (FAILED(hr)) {
				return DISP_E_TYPEMISMATCH;
			}
			return pOutput_->Write(param.bstrVal, SysStringLen(param.bstrVal), FALSE);
		}
		else if (dispIdMember == 1) {
			// writeLiteral\bh
			CComVariant param;
			hr = param.ChangeType(VT_UI4, &(pDispParams->rgvarg[0]));
			if (FAILED(hr)) {
				return DISP_E_TYPEMISMATCH;
			}

			ULONG idx = param.ulVal;

			if (literals_.GetCount() <= idx) {
				// ͈͊Ȍꍇ͉Ȃ
				return S_FALSE;
			}
			const CAtlStringW& line = literals_.GetAt(idx);
			return pOutput_->Write(line, line.GetLength(), FALSE);
		}

		ATLASSERT(false);
		return DISP_E_MEMBERNOTFOUND;
	}

protected:

	CComPtr<ITemplateSourceWriter2> pOutput_;

	CAtlArray<CAtlStringW> literals_;
};


/**
 * XNvgɊ֌WȂʂȕ̒ۃNX
 */
template<class This>
class CAbstractScriptBuilder
	: public IScriptBuilder
	, public IActiveScriptSite
{
public:

	HRESULT FinalConstruct(void) throw()
	{
		try {
			HRESULT hr;

			// o̓C^
			hr = CreateOutputStreamWriter(NULL, &pWriter_);
			if (FAILED(hr)) {
				return hr;
			}

			// eRNV
			pLiteralDispatchImpl_ = NULL;
			hr = CComObject<CLiteralDispatchImpl>::CreateInstance(&pLiteralDispatchImpl_);
			if (FAILED(hr)) {
				return hr;
			}
			pLiteralDispatchImpl_->AddRef();

			hr = pLiteralDispatchImpl_->SetWriter(pWriter_);
			if (FAILED(hr)) {
				return hr;
			}

			// eRNVuOutvƂOŊOIuWFNgƂăoCh
			externals_.SetAt(L"Out", pLiteralDispatchImpl_);
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	void FinalRelease() throw()
	{
		pLiteralDispatchImpl_->Release();
		pLiteralDispatchImpl_ = NULL;
		pWriter_.Release();
	}

	///////// IScriptBuilder //////////

	virtual HRESULT __stdcall Write(LPCWSTR v_pBuf, UINT v_siz, BOOL v_scriptlet) throw()
	{
		if ( !v_pBuf || v_siz == 0) {
			return S_FALSE;
		}

		// XNvgbg
		if (v_scriptlet) {
			if (v_pBuf[0] == '=') {
				// <%= ` %> ]XNvgbg
				if (v_siz == 1) {
					return S_FALSE;
				}
				return ((This*) this)->AddEvalOutputCode(v_pBuf + 1, v_siz - 1);
			}
			else {
				return ((This*) this)->AddScript(v_pBuf, v_siz);
			}
		}

		// e
		try {
			UINT idx = pLiteralDispatchImpl_->AddLiteral(v_pBuf, v_siz);
			return ((This*) this)->AddLiteralOutputCode(idx);
		}
		catch (...) {
			return E_FAIL;
		}
	}

	virtual HRESULT __stdcall set_Codepage(UINT v_codepage) throw()
	{
		// pWriter̃R[hy[WƋL
		return pWriter_->set_Codepage(v_codepage);
	}

	virtual HRESULT __stdcall get_Codepage(UINT* v_pCodepage) throw()
	{
		// pWriter̃R[hy[WƋL
		return pWriter_->get_Codepage(v_pCodepage);
	}

	virtual HRESULT __stdcall Clear() throw()
	{
		try {
			pLiteralDispatchImpl_->Reset();
			script_.Empty();
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	/**
	 * XNvg̎sʂi[Xg[Zbg܂B
	 * @param v_pStm o̓Xg[
	 * @return HR
	 */
	virtual HRESULT __stdcall SetOutputStream(ISequentialStream* v_pStm) throw()
	{
		return pWriter_->SetStream(v_pStm);
	}

	/**
	 * XNvg̎sʂi[Xg[擾܂B
	 * @param v_ppStm o͐Xg[i[|C^
	 * @return HR
	 */
	virtual HRESULT __stdcall GetOutputStream(ISequentialStream** v_ppStm) throw()
	{
		return pWriter_->GetStream(v_ppStm);
	}

	/**
	 * XNvg̃O[oReLXgɃIuWFNgƂăoChOIuWFNg
	 * o^܂B
	 * @param v_pName IuWFNg̖O
	 * @param v_pUnk IuWFNg
	 * @return HR
	 */
	virtual HRESULT __stdcall RegistExternalObject(LPCWSTR v_pName, IUnknown* v_pUnk) throw()
	{
		try {
			externals_.SetAt(v_pName, v_pUnk);
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	/**
	 * XNvgs܂B
	 * @return HR
	 */
	virtual HRESULT __stdcall Execute(BSTR* v_pErrorMessage) throw()
	{
		HRESULT hr;

		// XNvgGW̍\z
		CComPtr<IActiveScript> pScriptEngine;
		hr = pScriptEngine.CoCreateInstance(__uuidof(This::ACTIVESCRIPT));
		if (FAILED(hr)) {
			return hr;
		}

		// TCg̓o^
		hr = pScriptEngine->SetScriptSite(this);
		if (FAILED(hr)) {
			return hr;
		}

		// OIuWFNg̓o^
		POSITION pos = externals_.GetStartPosition();
		while (pos) {
			CAtlMap<CAtlStringW, CComPtr<IUnknown> >::CPair* pair = externals_.GetNext(pos);
			if (pair) {
				hr = pScriptEngine->AddNamedItem(pair->m_key, SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
				if (FAILED(hr)) {
					return hr;
				}
			}
		}

		// \[X̓ǂݍ
		CComQIPtr<IActiveScriptParse> pParser(pScriptEngine);
		hr = pParser->InitNew();
		if (FAILED(hr)) {
			return hr;
		}

		EXCEPINFO excepInfo;
		hr = pParser->ParseScriptText(script_, NULL, NULL, NULL, 0, 0, 0, NULL, &excepInfo);
		if (FAILED(hr)) {
			return hr;
		}

		// ڑ
		scripterror_ = S_OK;
		errorMessage_.Empty();

		hr = pScriptEngine->SetScriptState(SCRIPTSTATE_CONNECTED);
		if (SUCCEEDED(hr)) {
			hr = pScriptEngine->SetScriptState(SCRIPTSTATE_CLOSED);
		}

		if (v_pErrorMessage) {
			errorMessage_.CopyTo(v_pErrorMessage);
		}
		if (FAILED(hr) && SUCCEEDED(scripterror_)) {
			scripterror_ = hr;
		}

		return scripterror_;
	}

	///////// IActiveScriptSite //////////

	virtual HRESULT __stdcall GetLCID(LCID *plcid) throw()
	{
		if ( !plcid) {
			return E_POINTER;
		}
		*plcid = GetACP();
		return S_OK;
	}
    
    virtual HRESULT __stdcall GetItemInfo( 
        /* [in] */ LPCOLESTR pstrName,
        /* [in] */ DWORD dwReturnMask,
        /* [out] */ IUnknown **ppiunkItem,
        /* [out] */ ITypeInfo **ppti) throw()
	{
		CAtlMap<CAtlStringW, CComPtr<IUnknown> >::CPair* pPair = externals_.Lookup(pstrName);
		if (pPair) {
			HRESULT hr;
			if (dwReturnMask & SCRIPTINFO_IUNKNOWN) {
				hr = pPair->m_value.CopyTo(ppiunkItem);
				if (FAILED(hr)) {
					return hr;
				}
			}
			if (dwReturnMask & SCRIPTINFO_ITYPEINFO) {
				*ppti = NULL;
			}
			return S_OK;
		}
		return TYPE_E_ELEMENTNOTFOUND;
	}
    
    virtual HRESULT __stdcall GetDocVersionString(BSTR *pbstrVersion) throw()
	{
		if ( !pbstrVersion) {
			return E_POINTER;
		}
		*pbstrVersion = SysAllocString(L"CAbstractScriptBuilder");
		return S_OK;
	}
    
    virtual HRESULT __stdcall OnScriptTerminate( 
        /* [in] */ const VARIANT *pvarResult,
        /* [in] */ const EXCEPINFO *pexcepinfo) throw()
	{
		return S_OK;
	}
    
    virtual HRESULT __stdcall OnStateChange(SCRIPTSTATE ssScriptState) throw()
	{
		return S_OK;
	}

    virtual HRESULT __stdcall OnScriptError(IActiveScriptError *pscripterror) throw()
	{
		try {
			scripterror_ = E_FAIL;
			errorMessage_.Empty();
			
			HRESULT hr;
			EXCEPINFO ei = {0};
			hr = pscripterror->GetExceptionInfo(&ei);
			if (FAILED(hr)) {
				return hr;
			}
			
			if (ei.bstrDescription) {
				errorMessage_ = ei.bstrDescription;
			}

			if (FAILED(ei.scode)) {
				scripterror_ = ei.scode;
			}
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}
    
    virtual HRESULT __stdcall OnEnterScript(void)
	{
		return S_OK;
	}
    
    virtual HRESULT __stdcall OnLeaveScript(void)
	{
		return S_OK;
	}

protected:

	HRESULT __stdcall AddLiteralOutputCode(UINT v_idx) throw(); // Ȃ

	HRESULT __stdcall AddEvalOutputCode(LPCWSTR v_pLine, UINT v_siz) throw(); // Ȃ

	HRESULT __stdcall AddScript(LPCWSTR v_pLine, UINT v_siz) throw(); // Ȃ

	CComObject<CLiteralDispatchImpl>* pLiteralDispatchImpl_;

	CComPtr<IOutputStreamWriter> pWriter_;

	CAtlStringW script_;

	CAtlMap<CAtlStringW, CComPtr<IUnknown> > externals_;

	HRESULT scripterror_;

	CComBSTR errorMessage_;
};

/**
 * VBScriptp̃XNvgr_
 */
class __declspec(uuid("{1E568A9C-7EC2-456d-B4BC-D9EB466CE9C0}"), novtable) CVBScriptBuilder
	: public CComObjectRoot
	, public CComCoClass<CVBScriptBuilder, &__uuidof(CVBScriptBuilder)>
	, public CAbstractScriptBuilder<CVBScriptBuilder>
{
public:
	DECLARE_OBJECT_DESCRIPTION("CVBScriptBuilder")

	BEGIN_COM_MAP(CVBScriptBuilder)
		COM_INTERFACE_ENTRY(IScriptBuilder)
		COM_INTERFACE_ENTRY(ITemplateSourceWriter2)
		COM_INTERFACE_ENTRY(ITemplateSourceWriter)
		COM_INTERFACE_ENTRY(IActiveScriptSite)
	END_COM_MAP()

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()
	DECLARE_PROTECT_FINAL_CONSTRUCT()

	typedef VBScript ACTIVESCRIPT;

	HRESULT FinalConstruct(void) throw()
	{
		return CAbstractScriptBuilder<CVBScriptBuilder>::FinalConstruct();
	}

	void FinalRelease() throw()
	{
		CAbstractScriptBuilder<CVBScriptBuilder>::FinalRelease();
	}

	HRESULT __stdcall AddLiteralOutputCode(UINT v_idx) throw()
	{
		try {
			CAtlStringW tmp;
			tmp.Format(L"Call Out.writeLiteral(%ld)\r\n", v_idx);
			script_ += tmp;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	HRESULT __stdcall AddEvalOutputCode(LPCWSTR v_pLine, UINT v_siz) throw()
	{
		ATLASSERT(v_pLine && v_siz);
		try {
			script_ += L"Call Out.write(";
			script_.Append(v_pLine, v_siz);
			script_ += L")\r\n";
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	HRESULT __stdcall AddScript(LPCWSTR v_pLine, UINT v_siz) throw()
	{
		try {
			script_.Append(v_pLine, v_siz);
			script_ += L"\r\n"; // XNvgbg͉sR[hŏI[
		}
		catch (...) {
			return E_OUTOFMEMORY;
		}
		return S_OK;
	}
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CVBScriptBuilder), CVBScriptBuilder)

/**
 * JScriptp̃XNvgr_
 */
class __declspec(uuid("{642881AD-012D-4d0d-8D5C-8CE4993F12B6}"), novtable) CJScriptBuilder
	: public CComObjectRoot
	, public CComCoClass<CJScriptBuilder, &__uuidof(CJScriptBuilder)>
	, public CAbstractScriptBuilder<CJScriptBuilder>
{
public:
	DECLARE_OBJECT_DESCRIPTION("CJScriptBuilder")

	BEGIN_COM_MAP(CJScriptBuilder)
		COM_INTERFACE_ENTRY(IScriptBuilder)
		COM_INTERFACE_ENTRY(ITemplateSourceWriter2)
		COM_INTERFACE_ENTRY(ITemplateSourceWriter)
		COM_INTERFACE_ENTRY(IActiveScriptSite)
	END_COM_MAP()

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()
	DECLARE_PROTECT_FINAL_CONSTRUCT()

	typedef JScript ACTIVESCRIPT;

	HRESULT FinalConstruct(void) throw()
	{
		return CAbstractScriptBuilder<CJScriptBuilder>::FinalConstruct();
	}

	void FinalRelease() throw()
	{
		CAbstractScriptBuilder<CJScriptBuilder>::FinalRelease();
	}

	HRESULT __stdcall AddLiteralOutputCode(UINT v_idx) throw()
	{
		try {
			CAtlStringW tmp;
			tmp.Format(L"Out.writeLiteral(%ld);\r\n", v_idx);
			script_ += tmp;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	HRESULT __stdcall AddEvalOutputCode(LPCWSTR v_pLine, UINT v_siz) throw()
	{
		ATLASSERT(v_pLine && v_siz);
		try {
			script_ += L"Out.write(";
			script_.Append(v_pLine, v_siz);
			script_ += L");\r\n";
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	HRESULT __stdcall AddScript(LPCWSTR v_pLine, UINT v_siz) throw()
	{
		try {
			script_.Append(v_pLine, v_siz);
		}
		catch (...) {
			return E_OUTOFMEMORY;
		}
		return S_OK;
	}
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CJScriptBuilder), CJScriptBuilder)


HRESULT __stdcall CreateScriptBuilder(const IID& riid, IScriptBuilder** v_ppBuilder) throw()
{
	if ( !v_ppBuilder) {
		return E_POINTER;
	}
	*v_ppBuilder = NULL;

	if (IsEqualIID(riid, __uuidof(VBScript))) {
		return CVBScriptBuilder::CreateInstance(v_ppBuilder);
	}
	else if (IsEqualIID(riid, __uuidof(JScript))){
		return CJScriptBuilder::CreateInstance(v_ppBuilder);
	}

	return E_NOINTERFACE;
}
