#include "stdafx.h"

#include "TemplateEvaluater.h"

#include "SimpleBuffer.h"

class __declspec(uuid("{E0AE56A4-1FFF-4ab2-AF06-88EF6CD4E49E}")) CTemplateSourceChunkBuilder
	: public CComObjectRoot
	, public CComCoClass<CTemplateSourceChunkBuilder, &__uuidof(CTemplateSourceChunkBuilder)>
	, public ITemplateSourceChunkBuilder
{
public:
	DECLARE_OBJECT_DESCRIPTION("CTemplateSourceChunkBuilder")

	BEGIN_COM_MAP(CTemplateSourceChunkBuilder)
		COM_INTERFACE_ENTRY(ITemplateSourceChunkBuilder)
		COM_INTERFACE_ENTRY(ITemplateSourceSeparateHandler)
	END_COM_MAP()

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()
	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct(void) throw()
	{
		return ClearBuffer();
	}

	void FinalRelease() throw()
	{
	}

	/////////// ITemplateSourceSeparateHandler ///////////////

	virtual HRESULT __stdcall putLiteral(BYTE c) throw()
	{
		try {
			if (lineType_ != LINE_TYPE_NORMAL) {
				HRESULT hr = putBreak();
				if (FAILED(hr)) {
					return hr;
				}
				lineType_ = LINE_TYPE_NORMAL;
			}
			buffer_.Add(c);
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall putScriptlet(BYTE c) throw()
	{
		try {
			if (lineType_ != LINE_TYPE_SCRIPTLET) {
				HRESULT hr = putBreak();
				if (FAILED(hr)) {
					return hr;
				}
				lineType_ = LINE_TYPE_SCRIPTLET;
			}
			buffer_.Add(c);
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall putBreak(void) throw()
	{
		if (lineType_ == LINE_TYPE_UNKNOWN) {
			// ̍sȂΉȂB
			return S_OK;
		}

		HRESULT hr = S_OK;
		try {
			// vZbTo^ɏ
			POSITION pos = processors_.GetHeadPosition();
			while (pos) {
				CComPtr<ITemplateSourceProcessor> processor(
					processors_.GetNext(pos));
				hr = processor->Process(
					buffer_.GetData(),
					buffer_.GetCount(),
					lineType_ == LINE_TYPE_SCRIPTLET
					);
				if (hr != S_OK) {
					// S_OKȊȌꍇA𒆒fB
					break;
				}
			}
		}
		catch (...) {
			hr = E_FAIL;
		}

		if (FAILED(ClearBuffer())) {
			return E_FAIL;
		}

		return hr;
	}

	/////////// ITemplateSourceChunkBuilder ////////////

	virtual HRESULT __stdcall RegisterProcessor(ITemplateSourceProcessor* v_pProcessor) throw()
	{
		if ( !v_pProcessor) {
			return E_INVALIDARG;
		}
		try {
			processors_.AddTail(v_pProcessor);
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall ClearBuffer(void) throw()
	{
		try {
			lineType_ = LINE_TYPE_UNKNOWN;
			buffer_.Clear();
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

protected:

	CInterfaceList<ITemplateSourceProcessor> processors_;

	CSimpleBuffer<BYTE> buffer_;

	typedef enum {
		LINE_TYPE_UNKNOWN = 0,
		LINE_TYPE_NORMAL,
		LINE_TYPE_SCRIPTLET
	} LINE_TYPE;

	LINE_TYPE lineType_;

};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CTemplateSourceChunkBuilder), CTemplateSourceChunkBuilder)

HRESULT __stdcall CreateTemplateSourceChunkBuilder(ITemplateSourceChunkBuilder** v_ppChunkBuilder) throw()
{
	return CTemplateSourceChunkBuilder::CreateInstance(v_ppChunkBuilder);
}
