#include "stdafx.h"

#include <activscp.h>

#include "../TemplateEvaluater/TemplateEvaluater.h"
#include "../TemplateEvaluater/ScriptObject.h"

class CApp
	: public CAtlExeModuleT<CApp>
{
public:
	HRESULT PreMessageLoop(int nShow) throw()
	{
		HRESULT hr = __super::PreMessageLoop(nShow);
		return FAILED(hr) ? hr : S_OK;
	}

	void RunMessageLoop(void) throw()
	{
		HRESULT hr;

		CComPtr<IScriptBuilder> pScriptBuilder;
		hr = CreateScriptBuilder(__uuidof(VBScript), &pScriptBuilder);
		ATLASSERT(SUCCEEDED(hr));

		CComPtr<ITemplateSourceChunkBuilder> pChunkBuilder;
		hr = CreateTemplateSourceChunkBuilder(&pChunkBuilder);
		ATLASSERT(SUCCEEDED(hr));

		CComPtr<ITemplateSourceProcessor> pChunkWriterProcessor;
		hr = CreateTemplateSourceEncodingProcessor(pScriptBuilder, &pChunkWriterProcessor);
		ATLASSERT(SUCCEEDED(hr));

		hr = pChunkBuilder->RegisterProcessor(pChunkWriterProcessor);
		ATLASSERT(SUCCEEDED(hr));

		CComPtr<ITemplateSourceSplitter> pReader;
		hr = CreateTemplateSourceSplitter(pChunkBuilder, &pReader);
		ATLASSERT(SUCCEEDED(hr));

		CComPtr<IStream> pOutputStm;
		hr = SHCreateStreamOnFile(
			_TEXT("output.html"),
			STGM_CREATE | STGM_WRITE,
			&pOutputStm);
		ATLASSERT(SUCCEEDED(hr));

		CComPtr<IStream> pStm;
		hr = SHCreateStreamOnFile(
			_TEXT("template.html"),
			STGM_READ | STGM_SHARE_DENY_WRITE,
			&pStm);
		ATLASSERT(SUCCEEDED(hr));

		hr = pReader->Parse(pStm);
		ATLASSERT(SUCCEEDED(hr));

		hr = pScriptBuilder->SetOutputStream(pOutputStm);
		ATLASSERT(SUCCEEDED(hr));

		CComPtr<IScriptObject> obj;
		hr = CreateScriptObject(&obj);
		ATLASSERT(SUCCEEDED(hr));

		CComVariant value1(1234);
		hr = obj->put_item(CComVariant(L"value1"), value1);
		ATLASSERT(SUCCEEDED(hr));

		CComVariant value2(L"ABCD");
		hr = obj->put_item(CComVariant(L"value2"), value2);
		ATLASSERT(SUCCEEDED(hr));

		CComPtr<IScriptObject> obj2;
		hr = CreateScriptObject(&obj2);
		ATLASSERT(SUCCEEDED(hr));

		CComVariant value3(L"9999");
		hr = obj2->put_item(CComVariant(L"value3"), value3);
		ATLASSERT(SUCCEEDED(hr));

		CComVariant value4(L"WXYZ");
		hr = obj2->put_item(CComVariant(L"value4"), value4);
		ATLASSERT(SUCCEEDED(hr));

		hr = obj->put_item(CComVariant(L"subext"), CComVariant(obj2));
		ATLASSERT(SUCCEEDED(hr));

		hr = pScriptBuilder->RegistExternalObject(L"ext", obj);

		CComBSTR errorMessage;
		hr = pScriptBuilder->Execute(&errorMessage);
		if (FAILED(hr) && errorMessage) {
			MessageBoxW(NULL, errorMessage, NULL, MB_ICONERROR | MB_OK);
		}
		ATLASSERT(SUCCEEDED(hr));
	}
};

CApp _AtlModule;

int _tmain(int argc, _TCHAR* argv[])
{
	return _AtlModule.WinMain(SW_SHOWNORMAL);
}

