#pragma once

#include "ItemSelectDlg.h"

#include <map>
#include <list>

class ItemInfo
{
public:
	ItemInfo()
		: itemtype_( ItemType::ITEMTYPE_NONE )
	{
	}

	ItemInfo( const ItemInfo& v_other )
		: itemtype_( v_other.itemtype_ )
		, item_( v_other.item_ )
	{
	}

	~ItemInfo()
	{
	}

	ItemInfo& operator=( const ItemInfo& v_other )
	{
		itemtype_ = v_other.itemtype_;
		item_ = v_other.item_;
	}

	enum ItemType
	{
		ITEMTYPE_NONE,
		ITEMTYPE_LINKED_IMAGE,
		ITEMTYPE_LINKED_HTML,
		ITEMTYPE_IMAGE
	};

	void setItemType( ItemType v_itemtype )
	{
		itemtype_ = v_itemtype;
	}

	void setItem( const CString& v_item )
	{
		item_ = v_item;
	}

	ItemType getItemType() const
	{
		return itemtype_;
	}

	CString getItem() const
	{
		return item_;
	}

protected:

	ItemType itemtype_;
	CString item_;

};

class CDocumentParser :
	public std::list<ItemInfo>
{
public:
	CDocumentParser( const CItemSelectInfo& v_selectInfo );
	virtual ~CDocumentParser(void);

	HRESULT parse( IHTMLDocument2* v_pDoc );

protected:

	HRESULT parseFrame( IHTMLDocument2* v_pDoc );

	HRESULT parseDocument( IHTMLDocument2* v_pDoc );

protected:

	const CItemSelectInfo& selectInfo_;

};
