#include "StdAfx.h"
#include ".\itemselectdlg.h"

#include <shlobj.h>

CItemSelectDlg::CItemSelectDlg(void)
{
	load_setting();
}

CItemSelectDlg::~CItemSelectDlg(void)
{
}

void CItemSelectDlg::load_setting()
{
	HKEY context = NULL;
	if( ERROR_SUCCESS != RegOpenKeyEx( HKEY_CURRENT_USER, "Software\\MkImgPage", 0, KEY_ALL_ACCESS, &context ) ) {
		return;
	}

	TCHAR buffer[ MAX_PATH ];
	DWORD temp;
	DWORD len;

	len = MAX_PATH;
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("temp_path"), NULL, NULL, (BYTE*) buffer, &len ) ) {
		temp_path_ = buffer;
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("select_linked_image"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		select_linked_image_ = ( temp != 0 );
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("select_linked_html"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		select_linked_html_ = ( temp != 0 );
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("select_image"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		select_image_ = ( temp != 0 );
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("save_mode"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		save_mode_ = (int) temp;
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("open_mode"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		open_mode_ = (int) temp;
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("make_temp_name"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		temp_name_ = ( temp != 0 );
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("use_item_limit"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		use_item_limit_ = ( temp != 0 );
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("item_limit"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		item_limit_ = (int) temp;
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("item_start"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		item_start_ = (int) temp;
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("use_image_size"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		use_image_size_ = ( temp != 0 );
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("image_size_width"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		image_size_width_ = (int) temp;
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("image_size_height"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		image_size_height_ = (int) temp;
	}

	len = sizeof( DWORD );
	if( ERROR_SUCCESS == RegQueryValueEx( context, _TEXT("use_linked_url"), NULL, NULL, (BYTE*) &temp, &len ) ) {
		use_linked_url_ = ( temp != 0 );
	}

	RegCloseKey( context );
}

void CItemSelectDlg::save_setting()
{
	HKEY context = NULL;
	if( ERROR_SUCCESS != RegCreateKeyEx(
		HKEY_CURRENT_USER,
		"Software\\MkImgPage",
		0,
		NULL,
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&context,
		NULL
	) )
	{
		return;
	}

	DWORD tmp;

	RegSetValueEx( context, _TEXT("temp_path"), NULL, REG_SZ, (BYTE*)(LPCTSTR) temp_path_, temp_path_.GetLength() + 1 );

	tmp = select_linked_image_ ? 1 : 0;
	RegSetValueEx( context, _TEXT("select_linked_image"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = select_linked_html_ ? 1 : 0;
	RegSetValueEx( context, _TEXT("select_linked_html"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = select_image_ ? 1 : 0;
	RegSetValueEx( context, _TEXT("select_image"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = (DWORD) save_mode_;
	RegSetValueEx( context, _TEXT("save_mode"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = (DWORD) open_mode_;
	RegSetValueEx( context, _TEXT("open_mode"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = temp_name_ ? 1 : 0;
	RegSetValueEx( context, _TEXT("make_temp_name"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = use_item_limit_ ? 1 : 0;
	RegSetValueEx( context, _TEXT("use_item_limit"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = (DWORD) item_limit_;
	RegSetValueEx( context, _TEXT("item_limit"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = (DWORD) item_start_;
	RegSetValueEx( context, _TEXT("item_start"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = use_image_size_ ? 1 : 0;
	RegSetValueEx( context, _TEXT("use_image_size"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = (DWORD) image_size_width_;
	RegSetValueEx( context, _TEXT("image_size_width"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = (DWORD) image_size_height_;
	RegSetValueEx( context, _TEXT("image_size_height"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	tmp = use_linked_url_ ? 1 : 0;
	RegSetValueEx( context, _TEXT("use_linked_url"), NULL, REG_DWORD, (BYTE*) &tmp, sizeof(DWORD) );

	RegCloseKey( context );
}

LRESULT CItemSelectDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	CString tmp;

	tmp.LoadString( IDS_DDLIST_OPEN_MODE );

	int st = 0;
	for(;;) {
		int fp = tmp.Find( ";", st );
		if( fp == -1 ) {
			GetDlgItem( IDC_OPEN_MODE ).SendMessage( CB_ADDSTRING, 0, (LPARAM)(LPCTSTR) tmp.Mid( st ) );
			break;
		}
		GetDlgItem( IDC_OPEN_MODE ).SendMessage( CB_ADDSTRING, 0, (LPARAM)(LPCTSTR) tmp.Mid( st, fp - st ) );
		st = fp + 1;
	}
	GetDlgItem( IDC_OPEN_MODE ).SendMessage( CB_SETCURSEL, open_mode_, 0 );

	SetDlgItemText( IDC_FOLDER, temp_path_ );

	CheckDlgButton( IDC_SELECT_LINKED_IMAGE, select_linked_image_ ? BST_CHECKED : BST_UNCHECKED );
	CheckDlgButton( IDC_SELECT_LINKED_HTML, select_linked_html_ ? BST_CHECKED : BST_UNCHECKED );
	CheckDlgButton( IDC_SELECT_IMAGE, select_image_ ? BST_CHECKED : BST_UNCHECKED );

	CheckRadioButton( IDC_CREATE_VIRTUAL, IDC_CREATE_REAL, save_mode_ == 1 ? IDC_CREATE_REAL : IDC_CREATE_VIRTUAL );

	CheckDlgButton( IDC_USE_IMAGE_SIZE, use_image_size_ ? BST_CHECKED : BST_UNCHECKED );

	tmp.Format( "%d", image_size_width_ );
	SetDlgItemText( IDC_IMAGE_WIDTH, tmp );

	tmp.Format( "%d", image_size_width_ );
	SetDlgItemText( IDC_IMAGE_HEIGHT, tmp );


	CheckDlgButton( IDC_USE_ITEM_LIMIT, use_item_limit_ ? BST_CHECKED : BST_UNCHECKED );

	tmp.Format( "%d", item_start_ );
	SetDlgItemText( IDC_ITEM_START, tmp );
	
	tmp.Format( "%d", item_limit_ );
	SetDlgItemText( IDC_ITEM_LIMIT, tmp );

	SetDlgItemText( IDC_LINKED_URL, linked_url_ );


	CheckDlgButton( IDC_NAME_AUTO, temp_name_ ? BST_CHECKED : BST_UNCHECKED );
	CheckDlgButton( IDC_USE_LINKED_URL, use_linked_url_ ? BST_CHECKED : BST_UNCHECKED );

	return 1;
}

LRESULT CItemSelectDlg::OnOK(
	WORD wNotifyCode,
	WORD wID,
	HWND hWndCtl,
	BOOL& bHandled 
)
{
	select_linked_image_ = IsDlgButtonChecked( IDC_SELECT_LINKED_IMAGE ) != 0;
	select_linked_html_ = IsDlgButtonChecked( IDC_SELECT_LINKED_HTML ) != 0;
	select_image_ = IsDlgButtonChecked( IDC_SELECT_IMAGE ) != 0;

	save_mode_ = IsDlgButtonChecked( IDC_CREATE_REAL ) ? 1 : 0;
	temp_name_ = IsDlgButtonChecked( IDC_NAME_AUTO ) != 0;

	open_mode_ = (int) GetDlgItem( IDC_OPEN_MODE ).SendMessage( CB_GETCURSEL );
	if( open_mode_ < 0 || open_mode_ > 2 ) {
		open_mode_ = 0;
	}

	if( ! GetDlgItemText( IDC_FOLDER, temp_path_ ) ) {
		SetDefaultTempDir();
	}

	CString real_temp_path;
	ExpandEnvironmentStrings( temp_path_, real_temp_path.GetBuffer( MAX_PATH ), MAX_PATH );
	real_temp_path.ReleaseBuffer();

	const DWORD attr = GetFileAttributes( real_temp_path );
	if( attr == -1 || ( attr & FILE_ATTRIBUTE_DIRECTORY ) == 0 ) {
		CString message;
		message.LoadString( IDS_ERR_TEMP_PATH );
		MessageBox( message, "Error", MB_ICONERROR | MB_OK );
		return 1;
	}

	use_linked_url_ = IsDlgButtonChecked( IDC_USE_LINKED_URL ) != 0;
	use_item_limit_ = IsDlgButtonChecked( IDC_USE_ITEM_LIMIT ) != 0;
	use_image_size_ = IsDlgButtonChecked( IDC_USE_IMAGE_SIZE ) != 0;

	if( ! GetDlgItemText( IDC_LINKED_URL, linked_url_ ) || linked_url_.IsEmpty() ) {
		use_linked_url_ = false;
	}

	CString tmp;
	if( GetDlgItemText( IDC_IMAGE_WIDTH, tmp ) ) {
		image_size_width_ = atol( tmp );
	}
	if( GetDlgItemText( IDC_IMAGE_HEIGHT, tmp ) ) {
		image_size_height_ = atol( tmp );
	}
	if( GetDlgItemText( IDC_ITEM_LIMIT, tmp ) ) {
		item_limit_ = atoi( tmp );
	}
	if( GetDlgItemText( IDC_ITEM_START, tmp ) ) {
		item_start_ = atoi( tmp );
		if( item_start_ <= 0 ) {
			item_start_ = 1;
		}
	}

	EndDialog( IDOK );
	save_setting();

	return 1;
}

LRESULT CItemSelectDlg::OnCancel(
	WORD wNotifyCode,
	WORD wID,
	HWND hWndCtl,
	BOOL& bHandled 
)
{
	EndDialog( IDCANCEL );
	return 1;
}

LRESULT CItemSelectDlg::OnNextItemStartNumber(
	WORD wNotifyCode,
	WORD wID,
	HWND hWndCtl,
	BOOL& bHandled 
)
{
	CString tmp;
	int step = 0;
	if( GetDlgItemText( IDC_ITEM_LIMIT, tmp ) ) {
		step = atoi( tmp );
	}

	item_start_ += step;

	tmp.Format( "%d", item_start_ );
	SetDlgItemText( IDC_ITEM_START, tmp );
	
	return 1;
}

LRESULT CItemSelectDlg::OnSetDefaultTempPath(
	WORD wNotifyCode,
	WORD wID,
	HWND hWndCtl,
	BOOL& bHandled 
)
{
	SetDefaultTempDir();
	SetDlgItemText( IDC_FOLDER, temp_path_ );
	return 1;
}

LRESULT CItemSelectDlg::OnBrowseForFolder(
	WORD wNotifyCode,
	WORD wID,
	HWND hWndCtl,
	BOOL& bHandled 
)
{
	TCHAR path[ MAX_PATH ];

	BROWSEINFO binfo = { 0 };
	binfo.hwndOwner = m_hWnd;
	binfo.pszDisplayName = path;
	binfo.lpszTitle = "ꎞtH_̑I";
	binfo.ulFlags = BIF_BROWSEFORCOMPUTER | BIF_NEWDIALOGSTYLE | BIF_RETURNONLYFSDIRS;

	LPITEMIDLIST pidl = SHBrowseForFolder( &binfo );
	if( pidl != NULL ) {
		if( SHGetPathFromIDList( pidl, path ) ) {
			temp_path_ = path;
			SetDlgItemText( IDC_FOLDER, temp_path_ );
		}
		CoTaskMemFree( pidl );
	}

	return 1;
}

LRESULT CItemSelectDlg::OnOpenFolder(
	WORD wNotifyCode,
	WORD wID,
	HWND hWndCtl,
	BOOL& bHandled 
)
{
	CString real_temp_path;
	bool accept = false;

	if( GetDlgItemText( IDC_FOLDER, temp_path_ ) ) {
		ExpandEnvironmentStrings( temp_path_, real_temp_path.GetBuffer( MAX_PATH ), MAX_PATH );
		real_temp_path.ReleaseBuffer();
		if( ! real_temp_path.IsEmpty() ) {
			const DWORD attr = GetFileAttributes( real_temp_path );
			if( attr != -1 && ( attr & FILE_ATTRIBUTE_DIRECTORY ) != 0 ) {
				accept = true;
			}
		}
	}

	if( accept ) {
		ShellExecute( NULL, "OPEN", real_temp_path, NULL, NULL, SW_SHOWNORMAL );
	}
	else {
		MessageBeep( MB_ICONEXCLAMATION );
	}

	return 1;
}


