#include "stdafx.h"

#include "NameAcceptor.h"

class __declspec(uuid("{E232B2E4-A1FE-46fa-BE7B-318269EB8F45}")) CNegativeNameAcceptor
	: public INameAcceptor
	, public CComObjectRoot
{
public:
	DECLARE_OBJECT_DESCRIPTION("CNegativeNameAcceptor Object")

	BEGIN_COM_MAP(CNegativeNameAcceptor)
		COM_INTERFACE_ENTRY(INameAcceptor)
	END_COM_MAP( )

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		return S_OK;
	}

	HRESULT Init(INameAcceptor* v_pAcceptor) throw()
	{
		if ( !v_pAcceptor) {
			return E_INVALIDARG;
		}
		try {
			pAcceptor_ = v_pAcceptor;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall IsAcceptable(LPCWSTR v_pName) throw()
	{
		ATLASSERT(pAcceptor_);
		if ( !pAcceptor_) {
			return E_FAIL;
		}

		HRESULT hr = pAcceptor_->IsAcceptable(v_pName);
		if (FAILED(hr)) {
			return hr;
		}

		return (hr == S_FALSE) ? S_OK :  S_FALSE;
	}

protected:

	CComPtr<INameAcceptor> pAcceptor_;

};

HRESULT __stdcall CreateNegativeNameAcceptor(INameAcceptor* v_pAcceptor, INameAcceptor** v_ppNegativeAcceptor) throw()
{
	if ( !v_pAcceptor) {
		return E_INVALIDARG;
	}
	if ( !v_ppNegativeAcceptor) {
		return E_POINTER;
	}
	
	HRESULT hr;
	CComObject<CNegativeNameAcceptor>* pNegativeAcceptorImpl = NULL;
	hr = CComObject<CNegativeNameAcceptor>::CreateInstance(&pNegativeAcceptorImpl);
	if (FAILED(hr)) {
		return hr;
	}
	CComPtr<INameAcceptor> pNegativeAcceptor(pNegativeAcceptorImpl);

	hr = pNegativeAcceptorImpl->Init(v_pAcceptor);
	if (FAILED(hr)) {
		return hr;
	}

	return pNegativeAcceptor.CopyTo(v_ppNegativeAcceptor);
}
