// NameAcceptorSample.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

#include "../NameAcceptor/NameAcceptor.h"

class CNameAcceptorSample
	: public CAtlExeModuleT<CNameAcceptorSample>
{
public:

	HRESULT PreMessageLoop(int v_nShowCmd) throw()
	{
		return S_OK;
	}

	void RunMessageLoop() throw()
	{
		HRESULT hr;

		// SimpleAcceptor

		CComPtr<INameAcceptor> pSimpleAcceptor;
		hr = CreateSimpleNameAcceptor(L"abc/def/", &pSimpleAcceptor);
		ATLASSERT(SUCCEEDED(hr));

		hr = pSimpleAcceptor->IsAcceptable(NULL);
		ATLASSERT(hr == S_FALSE);

		hr = pSimpleAcceptor->IsAcceptable(L"");
		ATLASSERT(hr == S_FALSE);

		hr = pSimpleAcceptor->IsAcceptable(L"abc");
		ATLASSERT(hr == S_FALSE);

		hr = pSimpleAcceptor->IsAcceptable(L"abc/def");
		ATLASSERT(hr == S_FALSE);

		hr = pSimpleAcceptor->IsAcceptable(L"abc/def/");
		ATLASSERT(hr == S_OK);

		hr = pSimpleAcceptor->IsAcceptable(L"abc/def/ghi");
		ATLASSERT(hr == S_OK);

		// NegativeAcceptor
		
		CComPtr<INameAcceptor> pNegativeAcceptor;
		hr = CreateNegativeNameAcceptor(pSimpleAcceptor, &pNegativeAcceptor);
		ATLASSERT(hr == S_OK);

		hr = pNegativeAcceptor->IsAcceptable(NULL);
		ATLASSERT(hr == S_OK);

		hr = pNegativeAcceptor->IsAcceptable(L"");
		ATLASSERT(hr == S_OK);

		hr = pNegativeAcceptor->IsAcceptable(L"abc");
		ATLASSERT(hr == S_OK);

		hr = pNegativeAcceptor->IsAcceptable(L"abc/def");
		ATLASSERT(hr == S_OK);

		hr = pNegativeAcceptor->IsAcceptable(L"abc/def/");
		ATLASSERT(hr == S_FALSE);

		hr = pNegativeAcceptor->IsAcceptable(L"abc/def/ghi");
		ATLASSERT(hr == S_FALSE);

		// CreateStripedURLName
		
		CComBSTR val1;
		hr = CreateStripedURLName(NULL, &val1);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(val1 == NULL);

		hr = CreateStripedURLName(L"", &val1);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(val1 == NULL);

		hr = CreateStripedURLName(L"\\", &val1);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(val1 == NULL);

		hr = CreateStripedURLName(L"/", &val1);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(val1 == NULL);

		hr = CreateStripedURLName(L"aaa/", &val1);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(val1 == NULL);

		hr = CreateStripedURLName(L"aaa\\", &val1);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(val1 == NULL);

		CComBSTR val2;
		hr = CreateStripedURLName(L"abcdefg", &val2);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(lstrcmpW(L"abcdefg", val2) == 0);

		CComBSTR val3;
		hr = CreateStripedURLName(L"http://xxx.yyy.zzz/aaa", &val3);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(lstrcmpW(L"aaa", val3) == 0);

		CComBSTR val4;
		hr = CreateStripedURLName(L"http://xxx.yyy.zzz/aaa/xyz?query=aaa/bbb/cc", &val4);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(lstrcmpW(L"xyz", val4) == 0);

		// PatternNameAcceptor

		CComPtr<INameAcceptor> pPattern1;
		hr = CreatePatternNameAcceptor(L"", &pPattern1);
		ATLASSERT(SUCCEEDED(hr));
		hr = pPattern1->IsAcceptable(NULL);
		ATLASSERT(hr == S_OK);
		hr = pPattern1->IsAcceptable(L"");
		ATLASSERT(hr == S_OK);
		hr = pPattern1->IsAcceptable(L"A");
		ATLASSERT(hr == S_FALSE);

		CComPtr<INameAcceptor> pPattern2;
		hr = CreatePatternNameAcceptor(L"abc", &pPattern2);
		ATLASSERT(SUCCEEDED(hr));
		hr = pPattern2->IsAcceptable(NULL);
		ATLASSERT(hr == S_FALSE);
		hr = pPattern2->IsAcceptable(L"");
		ATLASSERT(hr == S_FALSE);
		hr = pPattern2->IsAcceptable(L"A");
		ATLASSERT(hr == S_FALSE);
		hr = pPattern2->IsAcceptable(L"abcd");
		ATLASSERT(hr == S_FALSE);
		hr = pPattern2->IsAcceptable(L"abc");
		ATLASSERT(hr == S_OK);

		CComPtr<INameAcceptor> pPattern3;
		hr = CreatePatternNameAcceptor(L"*", &pPattern3);
		ATLASSERT(SUCCEEDED(hr));
		hr = pPattern3->IsAcceptable(NULL);
		ATLASSERT(hr == S_OK);
		hr = pPattern3->IsAcceptable(L"");
		ATLASSERT(hr == S_OK);
		hr = pPattern3->IsAcceptable(L"A");
		ATLASSERT(hr == S_OK);

		CComPtr<INameAcceptor> pPattern4;
		hr = CreatePatternNameAcceptor(L"0123*.txt", &pPattern4);
		ATLASSERT(SUCCEEDED(hr));
		hr = pPattern4->IsAcceptable(NULL);
		ATLASSERT(hr == S_FALSE);
		hr = pPattern4->IsAcceptable(L"");
		ATLASSERT(hr == S_FALSE);
		hr = pPattern4->IsAcceptable(L"A.txt");
		ATLASSERT(hr == S_FALSE);
		hr = pPattern4->IsAcceptable(L"012");
		ATLASSERT(hr == S_FALSE);
		hr = pPattern4->IsAcceptable(L"0123456789.txt");
		ATLASSERT(hr == S_OK);
		hr = pPattern4->IsAcceptable(L"0123.txt");
		ATLASSERT(hr == S_OK);

		// MultiNameAcceptor

		CComPtr<IMultiNameAcceptor> pMultiNameAcceptor;
		hr = CreateMultiNameAcceptor(FALSE, &pMultiNameAcceptor);
		ATLASSERT(SUCCEEDED(hr));

		hr = pMultiNameAcceptor->IsAcceptable(NULL);
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor->IsAcceptable(L"");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor->IsAcceptable(L"0123.txt");
		ATLASSERT(hr == S_FALSE);

		hr = pMultiNameAcceptor->Add(pPattern2);
		ATLASSERT(SUCCEEDED(hr));
		hr = pMultiNameAcceptor->Add(pPattern4);
		ATLASSERT(SUCCEEDED(hr));

		hr = pMultiNameAcceptor->IsAcceptable(NULL);
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor->IsAcceptable(L"");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor->IsAcceptable(L"012");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor->IsAcceptable(L"0123456789.txt");
		ATLASSERT(hr == S_OK);
		hr = pMultiNameAcceptor->IsAcceptable(L"0123.txt");
		ATLASSERT(hr == S_OK);
		hr = pMultiNameAcceptor->IsAcceptable(L"A");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor->IsAcceptable(L"abcd");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor->IsAcceptable(L"abc");
		ATLASSERT(hr == S_OK);

		// StripedURLNameAcceptorAdaptor

		CComPtr<IStripedURLNameAcceptorAdaptor> pAcceptorAdaptor;
		hr = CreateStripedURLNameAcceptorAdaptor(pMultiNameAcceptor, &pAcceptorAdaptor);
		ATLASSERT(SUCCEEDED(hr));

		hr = pAcceptorAdaptor->IsAcceptable(NULL);
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"");
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"/");
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"\\");
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"012");
		ATLASSERT(hr == S_FALSE);

		hr = pAcceptorAdaptor->IsAcceptable(L"0123456789.txt");
		ATLASSERT(hr == S_OK);
		hr = pAcceptorAdaptor->IsAcceptable(L"0123.txt");
		ATLASSERT(hr == S_OK);
		hr = pAcceptorAdaptor->IsAcceptable(L"A");
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"abcd");
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"abc");
		ATLASSERT(hr == S_OK);

		hr = pAcceptorAdaptor->IsAcceptable(L"0123456789.txt/A");
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"0123.txt/");
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"0123.txt\\");
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"A\\A");
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"abcd\\");
		ATLASSERT(hr == S_FALSE);
		hr = pAcceptorAdaptor->IsAcceptable(L"abc\\abcd");
		ATLASSERT(hr == S_FALSE);

		hr = pAcceptorAdaptor->IsAcceptable(L"/A/B/C/0123456789.txt");
		ATLASSERT(hr == S_OK);
		hr = pAcceptorAdaptor->IsAcceptable(L"A/0123.txt");
		ATLASSERT(hr == S_OK);
		hr = pAcceptorAdaptor->IsAcceptable(L"/0123.txt");
		ATLASSERT(hr == S_OK);
		hr = pAcceptorAdaptor->IsAcceptable(L"\\0123.txt\\0123.txt");
		ATLASSERT(hr == S_OK);
		hr = pAcceptorAdaptor->IsAcceptable(L"abc/abc");
		ATLASSERT(hr == S_OK);
		hr = pAcceptorAdaptor->IsAcceptable(L"abc\\abc");
		ATLASSERT(hr == S_OK);

		// Complex Acceptor

		CComPtr<IMultiNameAcceptor> pMultiNameAcceptor2;
		hr = CreateMultiNameAcceptor(TRUE, &pMultiNameAcceptor2);
		ATLASSERT(SUCCEEDED(hr));

		hr = pMultiNameAcceptor2->Add(pSimpleAcceptor);
		ATLASSERT(SUCCEEDED(hr));
		hr = pMultiNameAcceptor2->Add(pAcceptorAdaptor);
		ATLASSERT(SUCCEEDED(hr));

		hr = pMultiNameAcceptor2->IsAcceptable(NULL);
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor2->IsAcceptable(L"");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor2->IsAcceptable(L"\\");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor2->IsAcceptable(L"/A/B/C/0123456789.txt");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor2->IsAcceptable(L"A/0123.txt");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor2->IsAcceptable(L"/0123.txt");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor2->IsAcceptable(L"\\0123.txt\\0123.txt");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor2->IsAcceptable(L"abc/abc");
		ATLASSERT(hr == S_FALSE);
		hr = pMultiNameAcceptor2->IsAcceptable(L"abc\\abc");
		ATLASSERT(hr == S_FALSE);

		hr = pMultiNameAcceptor2->IsAcceptable(L"abc/def/0123456789.txt");
		ATLASSERT(hr == S_OK);
		hr = pMultiNameAcceptor2->IsAcceptable(L"abc/def/0123.txt");
		ATLASSERT(hr == S_OK);
		hr = pMultiNameAcceptor2->IsAcceptable(L"abc/def/ghi/0123.txt");
		ATLASSERT(hr == S_OK);
		hr = pMultiNameAcceptor2->IsAcceptable(L"abc/def/0123/0123.txt");
		ATLASSERT(hr == S_OK);
		hr = pMultiNameAcceptor2->IsAcceptable(L"abc/def/abc");
		ATLASSERT(hr == S_OK);
		hr = pMultiNameAcceptor2->IsAcceptable(L"abc/def/abc/abc");
		ATLASSERT(hr == S_OK);
	}
};

CNameAcceptorSample _AtlModule;

int _tmain(int argc, _TCHAR* argv[])
{
	return _AtlModule.WinMain(SW_SHOWNORMAL);
}

