﻿using System.Collections.Generic;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline;
using MikuMikuDance.XNA.Model.ModelData;

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// プロセッサーにかける前のMMDモデル
    /// </summary>
    public class MMDModelIntermediate
    {
        /// <summary>
        /// XNA用モデル情報が入ったプロパティ
        /// </summary>
        public NodeContent RootNode { get; set; }
        /// <summary>
        /// XNAインポート情報
        /// </summary>
        public ContentIdentity Identity { get; set; }
        /// <summary>
        /// MMD用のボーン情報
        /// </summary>
        public List<MMDBoneData> Bones { get; set; }
        /// <summary>
        /// MMD用の表情情報
        /// </summary>
        public List<MMDSkinData> Skins { get; set; }
        /// <summary>
        /// MMD用の剛体情報
        /// </summary>
        public List<MMDRigid> Rigids { get; set; }
        /// <summary>
        /// MMD用のジョイント情報
        /// </summary>
        public List<MMDJoint> Joints { get; set; }
        /// <summary>
        /// 表情用に用いる全頂点数
        /// </summary>
        public int NumVertexForFace { get; set; }
    }
}
