﻿using System;

namespace MikuMikuDance.XNA.Model.ModelData
{
    /// <summary>
    /// 表情用の頂点データ(内部用)
    /// </summary>
    public class MMDSkinVertData
    {
        /// <summary>
        /// 対象頂点番号
        /// </summary>
        public UInt32 VertIndex { get; set; }//インポータ内ではbase内の配列番号になってる。Processorで修正
        /// <summary>
        /// 表情用の頂点座標(base), 表情用の頂点オフセット(それ以外)
        /// </summary>
        public float[] Pos { get; set; }
    }
    /// <summary>
    /// 表情データ
    /// </summary>
    public class MMDSkinData
    {
        /// <summary>
        /// 表情名
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 表情種別
        /// </summary>
        public MMDSkinType SkinType { get; set; }
        /// <summary>
        /// 表情で使用する頂点リスト
        /// </summary>
        public MMDSkinVertData[] SkinVerts { get; set; }
    }
}
