﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MikuMikuDance.XNA.Model;

namespace MikuMikuDance.XNA.Motion
{
    /// <summary>
    /// リピート再生時の動作フラグ
    /// </summary>
    [Flags]
    public enum RepeatBehaviorFlag
    {
        /// <summary>
        /// モデルワールド座標系を修正しない
        /// </summary>
        None = 0x00,
        //UseCenterBone= 0x00,//将来の拡張用
        /// <summary>
        /// モデルワールド座標系をモーションによるX座標の移動量で修正する
        /// </summary>
        ModifyByX = 0x04,
        /// <summary>
        /// モデルワールド座標系をモーションによるY座標の移動量で修正する
        /// </summary>
        ModifyByY = 0x08,
        /// <summary>
        /// モデルワールド座標系をモーションによるZ座標の移動量で修正する
        /// </summary>
        ModifyByZ = 0x10,
        /// <summary>
        /// モデルワールド座標系をモーションによる回転量で修正する
        /// </summary>
        ModifyByR = 0x20,
        /// <summary>
        /// モデルワールド座標系をモーションによるXYZの移動量で修正する
        /// </summary>
        ModifyByTranslation = ModifyByX | ModifyByY | ModifyByZ,
        /// <summary>
        /// モデルワールド座標系をモーションによる移動量と回転量で修正する
        /// </summary>
        ModifyByMove = ModifyByTranslation | ModifyByR,
    }
    struct RepeatBehavior
    {
        public RepeatBehaviorFlag Flag;
        public int BoneIndex;
        public void Init(RepeatBehaviorFlag flag, string BoneName, MMDBoneManager manager)
        {
            Flag = flag;
            BoneIndex = manager.IndexOf(BoneName);
        }
    }
}
