﻿
#if WINDOWS
using System.Runtime.InteropServices;
#endif

namespace MikuMikuDance.XNA
{
#if WINDOWS
    /// <summary>
    /// Win32API用のクラス。Windows用
    /// </summary>
    internal static class Win32API
    {
        [DllImport("kernel32")]
        internal static extern void GetSystemInfo(ref SYSTEM_INFO ptmpsi);

        [StructLayout(LayoutKind.Sequential)]
        public struct SYSTEM_INFO
        {
            public uint dwOemId;
            public uint dwPageSize;
            public uint lpMinimumApplicationAddress;
            public uint lpMaximumApplicationAddress;
            public uint dwActiveProcessorMask;
            public uint dwNumberOfProcessors;
            public uint dwProcessorType;
            public uint dwAllocationGranularity;
            public uint dwProcessorLevel;
            public uint dwProcessorRevision;
        }

    }
#endif
}
