﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MikuMikuDance.Motion;
using MikuMikuDance.Motion.Motion2;
using MikuMikuDance.Model.Ver1;
using MikuMikuDance.Model;
using MikuMikuDance.Motion.BaseBoneProcess;

namespace BaseBoneProcessor
{
    public partial class Form1 : Form
    {
        MMDModel1 m_model;
        MMDMotion2 m_motion;
        List<string> effectedList = new List<string>();
        public Form1()
        {
            InitializeComponent();
        }

        private void btnOpenMotion_Click(object sender, EventArgs e)
        {
            openFileDialog1.Title = "モーションを開く";
            openFileDialog1.FileName = "";
            openFileDialog1.Filter = "MikuMikuDanceモーション(*.vmd)|*.vmd|" +
                                "すべてのファイル(*.*)|*.*";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {//モーションの読み込み
                m_motion = (MMDMotion2)MotionManager.Read(openFileDialog1.FileName, MikuMikuDance.Motion.CoordinateType.RightHandedCoordinate);
                txtMotion.Text = openFileDialog1.FileName;
                if (!string.IsNullOrEmpty(txtModel.Text))
                {
                    btnRun.Enabled = true;
                }
            }
            
        }

        private void btnOpenModel_Click(object sender, EventArgs e)
        {
            openFileDialog1.Title = "モデルを開く";
            openFileDialog1.FileName = "";
            openFileDialog1.Filter = "MikuMikuDanceモデル(*.pmd)|*.pmd|" +
                                "すべてのファイル(*.*)|*.*";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {//モーションの読み込み
                m_model = (MMDModel1)ModelManager.Read(openFileDialog1.FileName, MikuMikuDance.Model.CoordinateType.RightHandedCoordinate);
                txtModel.Text = openFileDialog1.FileName;
                cmbBaseBone.Enabled = true;
                cmbBaseBone.Items.Clear();
                foreach (var it in m_model.Bones)
                {
                    if (it.ParentBoneIndex == 0xffff)
                    {
                        cmbBaseBone.Items.Add(it.BoneName);
                        effectedList.Add(it.BoneName);
                    }
                }
                cmbBaseBone.SelectedIndex = 0;
                if (!string.IsNullOrEmpty(txtModel.Text))
                {
                    btnRun.Enabled = true;
                }
            }
        }

        private void btnRun_Click(object sender, EventArgs e)
        {
            saveFileDialog1.Title = "モーションを保存";
            saveFileDialog1.FileName = "";
            saveFileDialog1.Filter = "MikuMikuDanceモーション(*.vmd)|*.vmd";
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {//モーションの変換と保存
                List<string> temp = new List<string>(effectedList);
                temp.Remove((string)cmbBaseBone.SelectedItem);
                BaseProcessor.Process(m_motion, (string)cmbBaseBone.SelectedItem, temp.ToArray(), textBox1.Text.Trim());
                MotionManager.Write(saveFileDialog1.FileName, m_motion);
                MessageBox.Show("モーションの変換と書き出しが終わりました");
            }
        }
    }
}
