/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.db;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mmosf.server.db.NotFountAccountException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccountManager {
    private static Log log = LogFactory.getLog(AccountManager.class);
    protected Map<String, String> accountMap = new HashMap<String, String>();

    public void loadAccountFile(String path) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] str = line.split(",");
                if (str.length != 2 || str[0].length() <= 0 || str[1].length() <= 0) continue;
                this.accountMap.put(str[0], str[1]);
            }
        }
        catch (IOException e) {
            log.error("file read error.", e);
        }
        try {
            br.close();
            isr.close();
            fis.close();
        }
        catch (IOException e) {
            log.error(e);
        }
    }

    public boolean isAccount(String userId) {
        return this.accountMap.containsKey(userId);
    }

    public String getPassword(String userId) throws NotFountAccountException {
        if (!this.isAccount(userId)) {
            throw new NotFountAccountException("not found account.");
        }
        return this.accountMap.get(userId);
    }
}

