/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.loginserver;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jp.sourceforge.mmosf.server.loginserver.SingleProcess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingleProcessThread2
implements Runnable {
    private static Log log = LogFactory.getLog(SingleProcessThread2.class);
    protected int interval;
    protected BlockingQueue<SingleProcess> queue = new LinkedBlockingQueue<SingleProcess>();

    public SingleProcessThread2(int interval) {
        this.queue.add(new NullProcess());
        this.interval = interval;
    }

    public void run() {
        long next = System.nanoTime();
        while (true) {
            next += (long)(this.interval * 1000000);
            block5: while (true) {
                try {
                    while (true) {
                        SingleProcess proc;
                        if ((proc = this.queue.take()) instanceof NullProcess) {
                            this.queue.put(proc);
                            break block5;
                        }
                        if (proc.isDeleted()) {
                            log.info("delete process:" + proc.hashCode());
                            continue;
                        }
                        if (!proc.process()) {
                            log.error("return false, SingleProcess.process.");
                            continue;
                        }
                        this.queue.put(proc);
                    }
                }
                catch (Exception e) {
                    log.error("error in process", e);
                    continue;
                }
                break;
            }
            long end = System.nanoTime();
            long interval = next - end;
            if (interval < 0L) {
                log.warn("pc process loop broken, interval = " + (double)interval / 1.0E9);
                next += (long)(this.interval * 1000000);
                continue;
            }
            try {
                Thread.sleep(interval / 1000000L);
                continue;
            }
            catch (InterruptedException e) {
                log.error("error in loop singleprocess sleep, ", e);
                continue;
            }
            break;
        }
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void addProcess(SingleProcess process) {
        try {
            this.queue.put(process);
        }
        catch (InterruptedException e) {
            log.error("error in addProcess, ", e);
        }
    }

    public void removeProcess(SingleProcess process) {
        process.setDelete(true);
    }

    protected class NullProcess
    extends SingleProcess {
        protected NullProcess() {
        }

        public boolean process() throws Exception {
            return true;
        }
    }
}

