/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.loginserver.test;

import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import jp.sourceforge.mmosf.server.ListeningServer;
import jp.sourceforge.mmosf.server.db.AccountManager;
import jp.sourceforge.mmosf.server.loginserver.LoginServer;
import jp.sourceforge.mmosf.server.loginserver.test.ClientConnection;
import jp.sourceforge.mmosf.server.object.ChatMessage;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLoginServer {
    private static final String LOGIN_HOST = "127.0.0.1";
    private static final int LOGIN_PORT = 2001;
    private static LoginServer loginServer;

    @BeforeClass
    public static void initServer() {
        try {
            LogFactory.getFactory().setAttribute("org.apache.commons.logging.log", "org.apache.commons.logging.impl.Log4JLogger");
            URL url = TestLoginServer.class.getClassLoader().getResource("jp/sourceforge/mmosf/server/conf/log4j.properties");
            PropertyConfigurator.configure(url.getPath());
            ListeningServer listeningServer = new ListeningServer(2000);
            loginServer = new LoginServer(2001);
            loginServer.setListeningServer(listeningServer);
            AccountManager manager = new AccountManager();
            URL path2 = TestLoginServer.class.getClassLoader().getResource("jp/sourceforge/mmosf/server/db/account.txt");
            manager.loadAccountFile(path2.getPath());
            loginServer.setAccountManager(manager);
            Thread th1 = new Thread(loginServer);
            th1.start();
            Thread th2 = new Thread(listeningServer);
            th2.start();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    @Test
    public void testLogin() {
        try {
            ClientConnection conn = new ClientConnection(LOGIN_HOST, 2001);
            Packet pac = this.login(conn, "aaa", "bbb");
            Assert.assertEquals((String)"not LoginPacket", (long)pac.getType(), (long)0L);
            Assert.assertTrue((String)"login failed", (boolean)pac.getBoolean("success"));
            conn.close();
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    protected Packet login(ClientConnection conn, String id, String password) throws NoSuchAlgorithmException, IOException, PacketFormatException, InterruptedException, UnknownHostException {
        Packet pac = PacketFactory.createHelloPcaket(null);
        conn.send(pac);
        pac = this.receive(conn);
        Assert.assertEquals((String)"not HelloPacket.", (long)pac.getType(), (long)4L);
        String random = pac.getString("random");
        pac = PacketFactory.createLoginRequestPcaket(id, password, random);
        conn.send(pac);
        pac = this.receive(conn);
        return pac;
    }

    protected Packet receive(ClientConnection conn) throws InterruptedException {
        while (!conn.isReceive()) {
            Thread.sleep(100L);
        }
        Packet pac = conn.receive();
        return pac;
    }

    @Test
    public void testConnect() {
        try {
            ClientConnection conn = new ClientConnection(LOGIN_HOST, 2001);
            Packet pac = this.login(conn, "aaa", "bbb");
            Assert.assertEquals((String)"not LoginPacket", (long)pac.getType(), (long)0L);
            Assert.assertTrue((String)"login failed", (boolean)pac.getBoolean("success"));
            conn.close();
            ClientConnection conn2 = new ClientConnection(pac.getString("hostadress"), pac.getInt("loginPort"));
            Packet sendPac = PacketFactory.createConnectRequestPcaket(pac.getString("connectid"));
            conn2.send(sendPac);
            pac = this.receive(conn2);
            Assert.assertEquals((long)pac.getType(), (long)5L);
            Assert.assertTrue((boolean)pac.getBoolean("success"));
            sendPac = PacketFactory.createMessagePacket(ChatMessage.createSay("A", "Hello !"));
            conn2.send(sendPac);
            pac = this.receive(conn2);
            Assert.assertEquals((long)pac.getType(), (long)2L);
            Assert.assertTrue((boolean)pac.getString("MESSAGE").equals("Hello !"));
            sendPac = PacketFactory.createLogoutPacket(true);
            conn2.send(sendPac);
            pac = this.receive(conn2);
            Assert.assertEquals((long)pac.getType(), (long)1L);
            Assert.assertTrue((boolean)pac.getBoolean("SUCCESS"));
            conn2.close();
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }
}

