/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object.action;

import jp.sourceforge.mmosf.server.object.PlayerCharactor;
import jp.sourceforge.mmosf.server.object.action.ActionCondition;
import jp.sourceforge.mmosf.server.object.quest.Quest;

public class ActionConditionQuest
extends ActionCondition {
    public static final int BEFORE = 0;
    public static final int JUST = 1;
    public static final int AFTER = 2;
    public static final int COMPLETE = 3;
    protected int questId;
    protected int indexPhrase;
    protected int subCondition;

    public ActionConditionQuest(int questId, int indexPhase, int subCondition) {
        this.questId = questId;
        this.indexPhrase = indexPhase;
        this.subCondition = subCondition;
    }

    public boolean isEnable(PlayerCharactor pc) {
        int index = pc.getQuestIndex(this.questId);
        if (index == -1) {
            switch (this.subCondition) {
                case 0: {
                    return !this.isCompleted(pc);
                }
                case 3: {
                    return this.isCompleted(pc);
                }
            }
            return false;
        }
        switch (this.subCondition) {
            case 0: {
                return pc.getQuest((int)index).indexPhase < this.indexPhrase;
            }
            case 1: {
                return pc.getQuest((int)index).indexPhase == this.indexPhrase;
            }
            case 2: {
                return pc.getQuest((int)index).indexPhase > this.indexPhrase;
            }
        }
        return false;
    }

    protected boolean isCompleted(PlayerCharactor pc) {
        for (Quest quest : pc.listCompleteQuest) {
            if (quest.id != this.questId) continue;
            return true;
        }
        return false;
    }
}

