/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import jp.sourceforge.mmosf.server.PacketCache;
import jp.sourceforge.mmosf.server.test.ByteArrayReadableChannel;
import org.junit.Assert;
import org.junit.Test;

public class TestPacketCache {
    @Test
    public void testPut1() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayInputStream bais = this.toIs("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayInputStream bais2 = this.splitInputStream(bais, 10);
            pc.put(bais2);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    protected ByteArrayInputStream splitInputStream(ByteArrayInputStream bais, int pos) {
        byte[] array = this.splitByteArray(bais, pos);
        ByteArrayInputStream bais2 = new ByteArrayInputStream(array);
        return bais2;
    }

    protected ByteArrayReadableChannel splitCannel(ByteArrayInputStream bais, int pos) {
        byte[] array = this.splitByteArray(bais, pos);
        ByteArrayReadableChannel bais2 = new ByteArrayReadableChannel(array);
        return bais2;
    }

    protected byte[] splitByteArray(ByteArrayInputStream bais, int pos) {
        byte[] data = new byte[pos];
        int size = bais.read(data, 0, pos);
        ByteBuffer buff = ByteBuffer.allocate(size);
        buff.put(data, 0, size);
        byte[] array = buff.array();
        return array;
    }

    protected ByteArrayInputStream toIs(String str) throws IOException {
        byte[] byteArray = this.toByteArray(str);
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        return bais;
    }

    protected ByteArrayReadableChannel toCannel(String str) throws IOException {
        byte[] byteArray = this.toByteArray(str);
        ByteArrayReadableChannel bais = new ByteArrayReadableChannel(byteArray);
        return bais;
    }

    protected byte[] toByteArray(String str) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.putInt(str.getBytes().length);
        baos.write(buff.array());
        baos.write(str.getBytes());
        byte[] byteArray = baos.toByteArray();
        return byteArray;
    }

    protected ByteArrayInputStream conbineIs(InputStream is1, InputStream is2) throws IOException {
        byte[] byteArray = this.combineByteArray(is1, is2);
        ByteArrayInputStream bais2 = new ByteArrayInputStream(byteArray);
        return bais2;
    }

    protected ByteArrayReadableChannel conbineCannel(InputStream is1, InputStream is2) throws IOException {
        byte[] byteArray = this.combineByteArray(is1, is2);
        ByteArrayReadableChannel bais2 = new ByteArrayReadableChannel(byteArray);
        return bais2;
    }

    protected byte[] combineByteArray(InputStream is1, InputStream is2) throws IOException {
        int length1 = is1.available();
        byte[] data1 = new byte[length1];
        int size1 = is1.read(data1, 0, length1);
        int length2 = is2.available();
        byte[] data2 = new byte[length2];
        int size2 = is2.read(data2, 0, length2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(data1, 0, size1);
        baos.write(data2, 0, size2);
        byte[] byteArray = baos.toByteArray();
        return byteArray;
    }

    @Test
    public void testPut2() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayInputStream bais = this.toIs("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayInputStream bais2 = this.splitInputStream(bais, 1);
            pc.put(bais2);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testPut3() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayInputStream bais = this.toIs("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayInputStream bais2 = this.splitInputStream(bais, 2);
            pc.put(bais2);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testPut4() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayInputStream bais = this.toIs("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayInputStream bais2 = this.splitInputStream(bais, 3);
            pc.put(bais2);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testPut5() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayInputStream bais = this.toIs("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayInputStream bais2 = this.splitInputStream(bais, 4);
            pc.put(bais2);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testPut6() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayInputStream bais1 = this.toIs("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayInputStream bais2 = this.toIs("\u306a\u3093\u3066\u3053\u3068\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            ByteArrayInputStream bais3 = this.conbineIs(bais1, bais2);
            ByteArrayInputStream bais4 = this.splitInputStream(bais3, 40);
            ByteArrayInputStream bais5 = this.splitInputStream(bais4, 20);
            pc.put(bais5);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais4);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            pc.put(bais3);
            String string2 = new String(pc.get().array());
            Assert.assertTrue((boolean)string2.equals("\u306a\u3093\u3066\u3053\u3068\u306f\u3042\u308a\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testPutCannel1() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayReadableChannel bais = this.toCannel("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayReadableChannel bais2 = this.splitCannel(bais, 10);
            pc.put(bais2);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testPutCannel2() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayReadableChannel bais = this.toCannel("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayReadableChannel bais2 = this.splitCannel(bais, 1);
            pc.put(bais2);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testPutChannel3() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayReadableChannel bais = this.toCannel("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayReadableChannel bais2 = this.splitCannel(bais, 2);
            pc.put(bais2);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testPutChannel4() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayReadableChannel bais = this.toCannel("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayReadableChannel bais2 = this.splitCannel(bais, 3);
            pc.put(bais2);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testPutChannel5() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayReadableChannel bais = this.toCannel("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayReadableChannel bais2 = this.splitCannel(bais, 4);
            pc.put(bais2);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testPutChannel6() {
        try {
            PacketCache pc = new PacketCache();
            ByteArrayReadableChannel bais1 = this.toCannel("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            ByteArrayReadableChannel bais2 = this.toCannel("\u306a\u3093\u3066\u3053\u3068\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            ByteArrayReadableChannel bais3 = this.conbineCannel(bais1, bais2);
            ByteArrayReadableChannel bais4 = this.splitCannel(bais3, 40);
            ByteArrayReadableChannel bais5 = this.splitCannel(bais4, 20);
            pc.put(bais5);
            Assert.assertFalse((boolean)pc.isGet());
            pc.put(bais4);
            Assert.assertTrue((boolean)pc.isGet());
            String string = new String(pc.get().array());
            Assert.assertTrue((boolean)string.equals("\u307e\u3060\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            pc.put(bais3);
            String string2 = new String(pc.get().array());
            Assert.assertTrue((boolean)string2.equals("\u306a\u3093\u3066\u3053\u3068\u306f\u3042\u308a\u307e\u305b\u3093\u3002"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }
}

