/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ConfigReader.h 1543 2006-09-18 10:05:27Z svn $
 *****************************************************************************/

#ifndef CONFIG_READER_H
#define CONFIG_READER_H

#include "Environment.h"

#include <cstdlib>

#include "apr_tables.h"

#include "Uncopyable.h"

using namespace std;

/**
 * @brief 設定ファイルを読み込むクラス．
 */
class ConfigReader: public Uncopyable
{
public:
    static apr_table_t *read(apr_pool_t *pool, const char *conf_file_path);

private:
    static const char COMMENT_CHAR;
    static const char QUOTE_CHAR;
    static const char ASSIGN_CHAR;

    static bool read_line(apr_pool_t *pool, const char **input,
                          const char **name, const char **value);
    static void read_param(apr_pool_t *pool, const char **input,
                           const char **name, const char **value);
    static void read_word(apr_pool_t *pool, const char **input,
                          const char **word);
    static void skip_space(const char **input);
    static void skip_line(const char **input);
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
