/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BBSThreadReader.h 1789 2006-10-11 16:20:48Z svn $
 *****************************************************************************/

#ifndef BBS_THREAD_READER_H
#define BBS_THREAD_READER_H

#include "Environment.h"

#include <cstdlib>

#include "apr_mmap.h"

#include "BBSThreadIO.h"
#include "File.h"

using namespace std;

class BBSThread;
class File;

/**
 * @brief BBS のスレッドをファイルから読み出すクラス．
 */
class BBSThreadReader: public BBSThreadIO
{
public:
    /**
     * コンストラクタです．
     *
     * @param[in] pool プール
     * @param[in] dir_path スレッドが保存されているディレクトリ
     */
    BBSThreadReader(apr_pool_t *pool, const char *dir_path);

    /**
     * スレッドを読み出します．
     *
     * @param[in] thread_id スレッドの ID
     * @param[out] bbs_thread スレッドデータ
     * @param[in] with_comments コメントも読み出すかどうか
     */
    void read(apr_size_t thread_id, BBSThread *bbs_thread,
              bool with_comments=true);
    /**
     * スレッドを読み出します．
     *
     * @param[in] thread_id スレッドの ID
     * @param[out] bbs_thread スレッドデータ
     * @param[out] bthread_file スレッドファイル
     */
    void read(apr_size_t thread_id, BBSThread **bbs_thread,
              apr_pool_t *pool, File& bthread_file) const;
    /**
     * スレッドが存在するかどうか調べます．
     *
     * @param[in] thread_id スレッドの ID
     * @retval true スレッドが存在する
     * @retval false スレッドが存在しない
     */
    bool is_exist(apr_size_t thread_id) const;

    static BBSThread *read(apr_pool_t *pool, const char *dir_path,
                           apr_size_t thread_id);

private:
    void read_and_check(File *bthread_file,
                        apr_mmap_t **bthread_file_map) const;

    static void check_format(apr_mmap_t *bthread_file_map);
    static void check_comment_count(apr_mmap_t *bthread_file_map);
    static void check_offset(apr_mmap_t *bthread_file_map);
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
