/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BBSThreadWriter.h 1848 2006-10-21 14:14:40Z svn $
 *****************************************************************************/

#ifndef BBS_THREAD_WRITER_H
#define BBS_THREAD_WRITER_H

#include "Environment.h"

#include "BBSThreadIO.h"

class BBSThread;

/**
 * @brief BBS のスレッドをファイルに書き込むクラス．
 */
class BBSThreadWriter: public BBSThreadIO
{
public:
    /**
     * コンストラクタです．
     *
     * @param[in] pool プール
     * @param[in] dir_path スレッドを保存するディレクトリ
     */
    BBSThreadWriter(apr_pool_t *pool, const char *dir_path);

    /**
     * スレッドを書き出します．
     *
     * @param[in] bbs_thread スレッドデータ
     */
    void write(BBSThread *bbs_thread);
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
