using System.Text;
using System.IO;

namespace FastBBSConfig
{
    public class BBSConfig
    {
        private string modulePath_;

        private string path_;
        private string baseUrl_;

        private string imagemagickPath_;

        private string dataDirPath_;
        private string fileDirPath_;
        private string tempDirPath_;

        private string indexTmplPath_;
        private string commentTmplPath_;
        private string threadTmplPath_;
        private string postThreadTmplPath_;

        private string imageDirPath_;
        private string stylesheetDirPath_;
        private string javascriptDirPath_;

        private string apacheConfigText_;

        public BBSConfig(string baseDir, string imagemagickPathArg)
        {
            imagemagickPath = imagemagickPathArg;

            modulePath_ = Path.Combine(baseDir, "mod_fast_bbs.so");

            baseUrl = "http://localhost/bbs";
            path    = "/bbs";

            dataDirPath = Path.Combine(baseDir, "data");
            fileDirPath = Path.Combine(baseDir, "file");
            tempDirPath = Path.Combine(baseDir, "temp");

            imageDirPath      = Path.Combine(baseDir, "img");
            stylesheetDirPath = Path.Combine(baseDir, "css");
            javascriptDirPath = Path.Combine(baseDir, "js");

            string tmplDirPath = Path.Combine(baseDir, "tmpl");

            indexTmplPath      = Path.Combine(tmplDirPath, "index.htm");
            commentTmplPath    = Path.Combine(tmplDirPath, "comment.htm");
            threadTmplPath     = Path.Combine(tmplDirPath, "thread.htm");
            postThreadTmplPath = Path.Combine(tmplDirPath, "post_thread.htm");
        }

        public string modulePath
        {
            get { return modulePath_; }
            set {
                modulePath_ = value;
                updateConfigText();
            }
        }

        public string path
        {
            get { return path_; }
            set {
                path_ = value;
                updateConfigText();
            }
        }

        public string baseUrl
        {
            get { return baseUrl_; }
            set {
                baseUrl_ = value;
                updateConfigText();
            }
        }

        public string imagemagickPath
        {
            get { return imagemagickPath_; }
            set {
                imagemagickPath_ = value;
                updateConfigText();
            }
        }

        public string dataDirPath
        {
            get { return dataDirPath_; }
            set {
                dataDirPath_ = value;
                updateConfigText();
            }
        }
        public string fileDirPath
        {
            get { return fileDirPath_; }
            set {
                fileDirPath_ = value;
                updateConfigText(); 
            }
        }
        public string tempDirPath
        {
            get { return tempDirPath_; }
            set {
                tempDirPath_ = value;
                updateConfigText();
            }
        }
        public string indexTmplPath
        {
            get { return indexTmplPath_; }
            set {
                indexTmplPath_ = value;
                updateConfigText();
            }
        }
        public string commentTmplPath
        {
            get { return commentTmplPath_; }
            set {
                commentTmplPath_ = value;
                updateConfigText();
            }
        }
        public string threadTmplPath
        {
            get { return threadTmplPath_; }
            set {
                threadTmplPath_ = value;
                updateConfigText();
            }
        }
        public string postThreadTmplPath
        {
            get { return postThreadTmplPath_; }
            set {
                postThreadTmplPath_ = value;
                updateConfigText();
            }
        }

        public string imageDirPath
        {
            get { return imageDirPath_; }
            set {
                imageDirPath_ = value;
                updateConfigText();
            }
        }

        public string stylesheetDirPath
        {
            get { return stylesheetDirPath_; }
            set {
                stylesheetDirPath_ = value;
                updateConfigText();
            }
        }

        public string javascriptDirPath
        {
            get { return javascriptDirPath_; }
            set {
                javascriptDirPath_ = value;
                updateConfigText();
            }
        }

        public string apacheConfigText
        {
            get { return apacheConfigText_; }
        }

        private void updateConfigText()
        {
            apacheConfigText_ = ApacheConfigCreator.create(this);
        }
    }
}
