#
#= mod_auth_hmac ticket generator
#
#--
#
# Copyright 2007 Takayuki Ogiso
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
#++
#
#Authors:: Takayuki Ogiso
#Copyright:: 2007 Takayuki Ogiso
#License:: http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
class AuthHmac
	require 'digest/sha1'
	
	# HASH block size
	#
	BLOCK_SIZE = 64
	
	#
	# Generate and return a AuthHmac ticket
	#
	#_key_ :: HMAC key (BASE64 encoded)
	#_expire_ :: Expiration
	#
	#return :: AuthHmac ticket
	#
	def self.ticket(key, expire)
		# RFC 822 format
		expire_string = expire.getgm.strftime("%a, %d %b %Y %H:%M:%S GMT")
		expire_string + "\t" + hmac(expire_string, key.unpack("m").join, Digest::SHA1)
	end
	
	#
	# Generate a HMAC digest
	#
	#_data_ :: Message
	#_key_ :: Secret key
	#_digest_ :: Digest object
	#
	#return :: HMAC, lower-case hexadecimal
	#
	def self.hmac(data, key, digest)
		ipad = (key.size > BLOCK_SIZE ? digest.digest(key) : key).unpack("C*")
		ipad = ipad.fill(0x00, ipad.size..BLOCK_SIZE - 1)
		opad = ipad.dup
		
		ipad.map! {|i| i ^ 0x36}
		opad.map! {|i| i ^ 0x5c}
		
		digest.hexdigest(opad.pack("C*") + digest.digest(ipad.pack("C*") + data))
	end
	private_class_method :hmac
end
