%define name        ntfs-module
%define version     0.1.4
%define release     0mol1.rhel4
%define kernel      %(uname -r)

Summary:     NTFS Kernel Module
Summary(ja): NTFSカーネルモジュール
Name:        %{name}
Version:     %{version}
Release:     %{release}
Source0:     ntfs-module-%{version}.tar.gz
License:     GNU GPL version2
Group:       System Environment/Kernel
Packager:    Keicho Kondo <dgel@users.sourceforge.jp>
Vendor:      Make One Linux Project
BuildRoot:   %{_tmppath}/%{name}-%{version}-root
BuildPrereq: mkkmodule

%description
ntfs-module is a kernel module which provides ntfs support.

%description -l ja
ntfs-moduleはntfsファイルシステムをサポートするカーネルモジュールです。

%prep
%setup -n ntfs-module-%{version}

%build
mkkmodule

%install
install -m 0644 -D ntfs.ko ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/kernel/fs/ntfs/ntfs.ko
touch ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/kernel/fs/ntfs/ntfs.ko

%clean
rm -rf ${RPM_BUILD_ROOT}

%package %{kernel}
Summary:     NTFS Kernel Module for RHEL
Summary(ja): RHEL用NTFSカーネルモジュール
Group:       System Environment/Kernel

%description %{kernel}
ntfs-module is a kernel module which provides ntfs support for RHEL.

%description %{kernel} -l ja
ntfs-moduleはntfsファイルシステムをサポートするRHEL用のカーネルモジュー
ルです。

%files %{kernel}
%defattr(-,root,root)
/lib/modules/%{kernel}/kernel/fs/ntfs/ntfs.ko

%post %{kernel}
if [ -f /boot/System.map-%{kernel} ]; then
        /sbin/depmod -a -F /boot/System.map-%{kernel} %{kernel} || :
else
        /sbin/depmod -a || :
fi

%postun %{kernel}
if [ -f /boot/System.map-%{kernel} ]; then
        /sbin/depmod -a -F /boot/System.map-%{kernel} %{kernel} || :
else
        /sbin/depmod -a || :
fi

%changelog
* Sun Apr 23 2006 Keicho Kondo <dgel@users.sourceforge.jp>
- initial build for Make One Linux.

