%define name    unionfs
%define version 1.0.14
%define release 0mol3.rhel4
%define kernel  %(uname -r)

Summary:     Unionfs is a stackable unification file system.
Summary(ja): Unionfsは２つのディレクトリを重ねて統合するファイルシステムです。
Name:        %{name}
Version:     %{version}
Release:     %{release}
Source0:     %{name}-%{version}.tar.gz
Patch0:      %{name}-1.0.14-bugfix.patch
LICENSE:     GNU GPL version 2
Group:       System Environment/Kernel
Packager:    Keicho Kondo <dgel@users.sourceforge.jp>
Vendor:      Make One Linux Project
BuildRoot:   %{_tmppath}/%{name}-%{version}-root

%description
Unionfs is a stackable unification file system, which can appear to
merge the contents of several directories.
This program contain 2 packages.
    unionfs-tools
    unionfs-module

%description -l ja
Unionfsは２つのディレクトリを重ねて統合するファイルシステムです。
このプログラムには下記の２つのパッケージが含まれています。
    unionfs-tools
    unionfs-module

%prep
rm -rf ${RPM_BUILD_ROOT}
%setup -n %{name}-%{version}
%patch0 -p1

%build
make

%install
install -m 0755 -d ${RPM_BUILD_ROOT}/usr/sbin
install -m 0755 -d ${RPM_BUILD_ROOT}/usr/share/man/man4
install -m 0755 -d ${RPM_BUILD_ROOT}/usr/share/man/man8
install -m 0755 -d ${RPM_BUILD_ROOT}/lib/module/%{kernel}/kernel/fs/unionfs
install -m 0755 -D unionctl ${RPM_BUILD_ROOT}/usr/sbin/unionctl
install -m 0755 -D uniondbg ${RPM_BUILD_ROOT}/usr/sbin/uniondbg
install -m 0755 -D unionimap ${RPM_BUILD_ROOT}/usr/sbin/unionimap
install -m 0644 -D man/unionfs.4 ${RPM_BUILD_ROOT}/usr/share/man/man4/unionfs.4
install -m 0644 -D man/uniondbg.8 ${RPM_BUILD_ROOT}/usr/share/man/man8/uniondbg.8
install -m 0644 -D man/unionctl.8 ${RPM_BUILD_ROOT}/usr/share/man/man8/unionctl.8
install -m 0644 -D man/unionimap.8 ${RPM_BUILD_ROOT}/usr/share/man/man8/unionimap.8
install -m 0644 -D unionfs.ko ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/kernel/fs/unionfs/unionfs.ko

%clean
rm -rf ${RPM_BUILD_ROOT}

%changelog
* Fri Mar 31 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.14-0mol3.rhel4
- added unionfs-1.0.14-bugfix.patch.
- added unionimap command.
* Tue Mar 28 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.14-0mol2.rhel4
- downgrade to 1.0.14.
* Fri Mar 24 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.1.3-0mol1.rhel4
- update to 1.1.3.
* Tue Jan 10 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-0mol2
- modified name, dgel to Keicho Kondo
* Sun Jan 08 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-0mol2
- modified Keicho's mail address
* Sun Jan 01 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-0mol1
- initial build for Make One Linux

#-----------------------------------------------------------------------

%package tools
Summary:     Control a unionfs file system
Summary(ja): unionfsを制御するプログラム
Group:       System Environment/Kernel

%description tools
unionfs-tools is a program for controling unionfs file system.

%description tools -l ja
unionfs-toolsはunionfsファイルシステムを制御するためのプログラムです。

%files tools
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING NEWS README
/usr/sbin/unionctl
/usr/sbin/uniondbg
/usr/sbin/unionimap
/usr/share/man/man8/unionctl.8.gz
/usr/share/man/man8/uniondbg.8.gz
/usr/share/man/man8/unionimap.8.gz

%changelog tools
* Fri Mar 31 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.14-0mol3.rhel4
- added unionfs-1.0.14-bugfix.patch.
- added unionimap command.
* Tue Mar 28 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.14-0mol2.rhel4
- downgrade to 1.0.14.
* Fri Mar 24 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.1.3-0mol1.rhel4
- update to 1.1.3.
* Tue Jan 10 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-0mol2
- modified name, dgel to Keicho Kondo
* Sun Jan 08 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-0mol2
- modified Keicho's mail address
* Sun Jan 01 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-0mol1
- initial build for Make One Linux
* Fri Nov 18 2005 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-mol1
- renamed package
* Mon Nov 7 2005 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-mod3
- add BuildPrereq tag
- downgrade to 1.0.12a
* Sun Oct 8 2005 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.14-mod1
- combine tools with module packages
- update to 1.0.14
* Mon Jun 13 2005 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-mod2
- recompile for CentOS 4.1
* Sun Jun 5 2005 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-mod1
- initial build for Make One Disk

#-----------------------------------------------------------------------

%package module-%{kernel}
Summary:     Unionfs Kernel Module
Summary(ja): Unionfsカーネルモジュール
Group:       System Environment/Kernel
BuildPrereq: ctags, e2fsprogs-devel

%description module-%{kernel}
unionfs-module is a kernel module which provides squashfs support.

%description module-%{kernel} -l ja
unionfs-moduleはunionfsファイルシステムをサポートするカーネルモジュールです。

%post module-%{kernel}
if [ -f /boot/System.map-%{kernel} ]; then
        /sbin/depmod -a -F /boot/System.map-%{kernel} %{kernel} || :
else
        /sbin/depmod -a || :
fi

%postun module-%{kernel}
if [ -f /boot/System.map-%{kernel} ]; then
        /sbin/depmod -a -F /boot/System.map-%{kernel} %{kernel} || :
else
        /sbin/depmod -a || :
fi

%files module-%{kernel}
%defattr(-,root,root)
/lib/modules/%{kernel}/kernel/fs/unionfs/unionfs.ko
/usr/share/man/man4/unionfs.4.gz

%changelog module-%{kernel}
* Tue Mar 28 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.14-0mol2.rhel4
- downgrade to 1.0.14.
* Fri Mar 24 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.1.3-0mol1.rhel4
- update to 1.1.3.
* Tue Jan 10 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-0mol2
- modified name, dgel to Keicho Kondo
* Sun Jan 08 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-0mol2
- modified Keicho's mail address
* Sun Jan 01 2006 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-0mol1
- initial build for Make One Linux
* Fri Nov 18 2005 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-mol1
- renamed package
* Mon Nov 7 2005 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.12a-mod3
- add BuildPrereq tag
- downgrade to 1.0.12a
* Sun Oct 9 2005 Keicho Kondo <dgel@users.sourceforge.jp> 1.0.14-mod1
- Initial build for Make One Disk

