<?php
require_once("common.php");

/**
 * O̕\
 */
function viewLogs($num) {
    global $logDirName, $logFileName, $maxKensu, $isViewIP;
    if (is_null($num) || !is_numeric($num)) {
         $num = 0;
    }

    if (!file_exists($logDirName . "/" . $logFileName)) {
	print "(O܂)";
    }
    else {
	$logFile = $logDirName . "/" . $logFileName;
	$lines = file($logFile);
	
	if (count($lines) == 0) {
	    print "(O܂)";
	}
	else {
	    // 烍O̓ǂݍ
	    $lines = array_reverse($lines);
	    $arr = array_chunk($lines, $maxKensu);
	    for ($ii = 0; $ii < count($arr[$num]); $ii++) {
		list($date, $ip, $title, $name, $message) = explode("<>", $arr[$num][$ii]);
		print '<span class="title">' . $title  . '</span><br>' . "\r\n";
		print "OF$name ";
		print "eF$date ";
		if ($isViewIP) {
		    print "IPF$ip";
		}
		print "<br>\r\n";
		print "$message<br>\r\n";

		if ($ii < count($arr[$num]) - 1) {
		    print "<hr>\r\n";
		}
	    }
	}
    }
    
}

/**
 * bZ[W\邽߂̔ԍ̃N
 */
function viewLogNumber($num) {
    global $logDirName, $logFileName, $maxKensu;
    if (is_null($num) || !is_numeric($num)) {
         $num = 0;
    }

    if (file_exists($logDirName . "/" . $logFileName)) {
	$logFile = $logDirName . "/" . $logFileName;
	$lines = file($logFile);
	
	if (count($lines) == 0 || (count($lines) / $maxKensu) == 0
	    || ((floor(count($lines) / $maxKensu) == 1) && (count($lines) % $maxKensu) == 0)) {
	    // Ȃ
	}
	else {
	    $divide = floor(count($lines) / $maxKensu);
	    $amari = count($lines) % $maxKensu;

	    if ($divide > 0 && $amari > 0) {
		$count = $divide + 1;
	    }
	    else if ($divide > 0 && $amari == 0) {
		$count = $divide;
	    }

	    for ($ii = 0; $ii < $count; $ii++) {
		if ($ii == $num) {
		    print '<b>' . ($ii + 1) . '</b>' . "\r\n";
		}
		else{
		    print '<a href="index.php?num=' . $ii . '">';
		    print $ii + 1;
		    print "</a>\r\n";
		}
	    }
	}
    }
}

/**
 * bZ[Wt@Cɏ
 *
 * @return 1ԂB߂ȂꍇfalseԂB
 */
function writeMessage($title, $name, $date, $ip, $message)
{
    global $logDirName, $logFileName;

    $title = eregi_replace("\r\n", "", htmlspecialchars($title, ENT_QUOTES));
    $title = eregi_replace("\n", "", $title);
    $name = eregi_replace("\r\n", "", htmlspecialchars($name, ENT_QUOTES));
    $name = eregi_replace("\n", "", $name);
    $date = eregi_replace("\r\n", "", htmlspecialchars($date, ENT_QUOTES));
    $date = eregi_replace("\n", "", $date);
    $ip = eregi_replace("\r\n", "", htmlspecialchars($ip, ENT_QUOTES));
    $ip = eregi_replace("\n", "", $ip);
    $message = eregi_replace("\r\n", "<br>", htmlspecialchars($message, ENT_QUOTES));
    $message = eregi_replace("\n", "<br>", $message);
    
    $input = "$date<>$ip<>$title<>$name<>$message\r\n";
    if (!$fp = fopen($logDirName . "/" . $logFileName, 'a')) {
	echo "$logDirName/$logFileNameJ܂B";
	return false;
    }
    
    if (fwrite($fp, $input) == false) {
	echo "$logDirName/$logFileNameɏ߂܂B";
	return false;
    }

    fclose($fp);

    return 1;
}

/**
 * uEUɃLbVȂ߂HTTPwb_[ݒB
 * ̊֐HTML^OLqOɎsKvB
 *
 * @param $charset R[hw肷Bw肵ȂꍇShift_JISɂȂB
 */
function printNoCacheHeader($charset = "Shift_JIS") {
    header("Content-Type: text/html; charset=" . $charset);
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");
}

?>

